/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.BackOffHandler;
import org.springframework.kafka.listener.DeliveryAttemptAware;
import org.springframework.kafka.listener.ExceptionClassifier;
import org.springframework.kafka.listener.FailedRecordTracker;
import org.springframework.kafka.listener.RecoveryStrategy;
import org.springframework.kafka.listener.RetryListener;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public abstract class FailedRecordProcessor
extends ExceptionClassifier
implements DeliveryAttemptAware {
    private static final BackOff NO_RETRIES_OR_DELAY_BACKOFF = new FixedBackOff(0L, 0L);
    private final BiFunction<ConsumerRecord<?, ?>, Exception, BackOff> noRetriesForClassified = (rec, ex) -> {
        if (!this.getClassifier().classify((Throwable)ex).booleanValue()) {
            return NO_RETRIES_OR_DELAY_BACKOFF;
        }
        return this.userBackOffFunction.apply((ConsumerRecord<?, ?>)rec, (Exception)ex);
    };
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final FailedRecordTracker failureTracker;
    private boolean commitRecovered;
    private BiFunction<ConsumerRecord<?, ?>, Exception, BackOff> userBackOffFunction = (rec, ex) -> null;
    private boolean seekAfterError = true;

    protected FailedRecordProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff) {
        this(recoverer, backOff, null);
    }

    protected FailedRecordProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff, @Nullable BackOffHandler backOffHandler) {
        this.failureTracker = new FailedRecordTracker(recoverer, backOff, backOffHandler, this.logger);
        this.failureTracker.setBackOffFunction(this.noRetriesForClassified);
    }

    protected boolean isCommitRecovered() {
        return this.commitRecovered;
    }

    public void setCommitRecovered(boolean commitRecovered) {
        this.commitRecovered = commitRecovered;
    }

    public void setBackOffFunction(BiFunction<ConsumerRecord<?, ?>, Exception, BackOff> backOffFunction) {
        Assert.notNull(backOffFunction, (String)"'backOffFunction' cannot be null");
        this.userBackOffFunction = backOffFunction;
    }

    public void setResetStateOnRecoveryFailure(boolean resetStateOnRecoveryFailure) {
        this.failureTracker.setResetStateOnRecoveryFailure(resetStateOnRecoveryFailure);
    }

    public void setResetStateOnExceptionChange(boolean resetStateOnExceptionChange) {
        this.failureTracker.setResetStateOnExceptionChange(resetStateOnExceptionChange);
    }

    public void setRetryListeners(RetryListener ... listeners) {
        this.failureTracker.setRetryListeners(listeners);
    }

    public boolean isSeekAfterError() {
        return this.seekAfterError;
    }

    public void setSeekAfterError(boolean seekAfterError) {
        this.seekAfterError = seekAfterError;
    }

    @Override
    public int deliveryAttempt(TopicPartitionOffset topicPartitionOffset) {
        return this.failureTracker.deliveryAttempt(topicPartitionOffset);
    }

    @Deprecated
    protected RecoveryStrategy getRecoveryStrategy(List<ConsumerRecord<?, ?>> records, Exception thrownException) {
        return this.getRecoveryStrategy(records, null, thrownException);
    }

    @Deprecated
    protected RecoveryStrategy getRecoveryStrategy(List<ConsumerRecord<?, ?>> records, @Nullable Consumer<?, ?> recoveryConsumer, Exception thrownException) {
        return this.failureTracker::recovered;
    }

    protected FailedRecordTracker getFailureTracker() {
        return this.failureTracker;
    }

    public void clearThreadState() {
        this.failureTracker.clearThreadState();
    }
}

