/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.config.MethodKafkaListenerEndpoint;
import org.springframework.kafka.listener.ContainerGroup;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.EndpointHandlerMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KafkaListenerEndpointRegistry
implements ListenerContainerRegistry,
DisposableBean,
SmartLifecycle,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final Map<String, MessageListenerContainer> unregisteredContainers = new ConcurrentHashMap<String, MessageListenerContainer>();
    private final Map<String, MessageListenerContainer> listenerContainers = new ConcurrentHashMap<String, MessageListenerContainer>();
    private int phase = 2147483547;
    private ConfigurableApplicationContext applicationContext;
    private boolean contextRefreshed;
    private boolean alwaysStartAfterRefresh = true;
    private volatile boolean running;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    @Override
    @Nullable
    public MessageListenerContainer getListenerContainer(String id) {
        Assert.hasText((String)id, (String)"Container identifier must not be empty");
        return this.listenerContainers.get(id);
    }

    @Override
    @Nullable
    public MessageListenerContainer getUnregisteredListenerContainer(String id) {
        MessageListenerContainer container = this.unregisteredContainers.get(id);
        if (container == null) {
            this.refreshContextContainers();
            return this.unregisteredContainers.get(id);
        }
        return null;
    }

    public void setAlwaysStartAfterRefresh(boolean alwaysStartAfterRefresh) {
        this.alwaysStartAfterRefresh = alwaysStartAfterRefresh;
    }

    @Override
    public Set<String> getListenerContainerIds() {
        return Collections.unmodifiableSet(this.listenerContainers.keySet());
    }

    @Override
    public Collection<MessageListenerContainer> getListenerContainers() {
        return Collections.unmodifiableCollection(this.listenerContainers.values());
    }

    @Override
    public Collection<MessageListenerContainer> getAllListenerContainers() {
        ArrayList<MessageListenerContainer> containers = new ArrayList<MessageListenerContainer>();
        containers.addAll(this.getListenerContainers());
        this.refreshContextContainers();
        containers.addAll(this.unregisteredContainers.values());
        return containers;
    }

    private void refreshContextContainers() {
        this.unregisteredContainers.clear();
        this.applicationContext.getBeansOfType(MessageListenerContainer.class, true, false).values().forEach(container -> this.unregisteredContainers.put(container.getListenerId(), (MessageListenerContainer)container));
    }

    public void registerListenerContainer(KafkaListenerEndpoint endpoint, KafkaListenerContainerFactory<?> factory) {
        this.registerListenerContainer(endpoint, factory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListenerContainer(KafkaListenerEndpoint endpoint, KafkaListenerContainerFactory<?> factory, boolean startImmediately) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        Assert.notNull(factory, (String)"Factory must not be null");
        String id = endpoint.getId();
        Assert.hasText((String)id, (String)"Endpoint id must not be empty");
        Map<String, MessageListenerContainer> map = this.listenerContainers;
        synchronized (map) {
            Assert.state((!this.listenerContainers.containsKey(id) ? 1 : 0) != 0, (String)("Another endpoint is already registered with id '" + id + "'"));
            MessageListenerContainer container = this.createListenerContainer(endpoint, factory);
            this.listenerContainers.put(id, container);
            ConfigurableApplicationContext appContext = this.applicationContext;
            String groupName = endpoint.getGroup();
            if (StringUtils.hasText((String)groupName) && appContext != null) {
                ContainerGroup group;
                List<MessageListenerContainer> containerGroup;
                if (appContext.containsBean(groupName)) {
                    containerGroup = (List)appContext.getBean(groupName, List.class);
                    group = (ContainerGroup)appContext.getBean(groupName + ".group", ContainerGroup.class);
                } else {
                    containerGroup = new ArrayList();
                    appContext.getBeanFactory().registerSingleton(groupName, containerGroup);
                    group = new ContainerGroup(groupName);
                    appContext.getBeanFactory().registerSingleton(groupName + ".group", (Object)group);
                }
                containerGroup.add(container);
                group.addContainers(container);
            }
            if (startImmediately) {
                this.startIfNecessary(container);
            }
        }
    }

    protected MessageListenerContainer createListenerContainer(KafkaListenerEndpoint endpoint, KafkaListenerContainerFactory<?> factory) {
        Object listenerContainer;
        MethodKafkaListenerEndpoint mkle;
        Object bean;
        if (endpoint instanceof MethodKafkaListenerEndpoint && (bean = (mkle = (MethodKafkaListenerEndpoint)endpoint).getBean()) instanceof EndpointHandlerMethod) {
            EndpointHandlerMethod ehm = (EndpointHandlerMethod)bean;
            ehm = new EndpointHandlerMethod(ehm.resolveBean((BeanFactory)this.applicationContext), ehm.getMethodName());
            mkle.setBean(ehm.resolveBean((BeanFactory)this.applicationContext));
            mkle.setMethod(ehm.getMethod());
        }
        if ((listenerContainer = factory.createListenerContainer(endpoint)) instanceof InitializingBean) {
            try {
                ((InitializingBean)listenerContainer).afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Failed to initialize message listener container", (Throwable)ex);
            }
        }
        int containerPhase = listenerContainer.getPhase();
        if (listenerContainer.isAutoStartup() && containerPhase != 2147483547) {
            if (this.phase != 2147483547 && this.phase != containerPhase) {
                throw new IllegalStateException("Encountered phase mismatch between container factory definitions: " + this.phase + " vs " + containerPhase);
            }
            this.phase = listenerContainer.getPhase();
        }
        return listenerContainer;
    }

    public void destroy() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            listenerContainer.destroy();
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            this.startIfNecessary(listenerContainer);
        }
        this.running = true;
    }

    public void stop() {
        this.running = false;
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            listenerContainer.stop();
        }
    }

    public void stop(Runnable callback) {
        this.running = false;
        Collection<MessageListenerContainer> listenerContainersToStop = this.getListenerContainers();
        if (listenerContainersToStop.size() > 0) {
            AggregatingCallback aggregatingCallback = new AggregatingCallback(listenerContainersToStop.size(), callback);
            for (MessageListenerContainer listenerContainer : listenerContainersToStop) {
                if (listenerContainer.isRunning()) {
                    listenerContainer.stop(aggregatingCallback);
                    continue;
                }
                aggregatingCallback.run();
            }
        } else {
            callback.run();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.applicationContext)) {
            this.contextRefreshed = true;
        }
    }

    private void startIfNecessary(MessageListenerContainer listenerContainer) {
        if (this.contextRefreshed && this.alwaysStartAfterRefresh || listenerContainer.isAutoStartup()) {
            listenerContainer.start();
        }
    }

    private static final class AggregatingCallback
    implements Runnable {
        private final AtomicInteger count;
        private final Runnable finishCallback;

        private AggregatingCallback(int count, Runnable finishCallback) {
            this.count = new AtomicInteger(count);
            this.finishCallback = finishCallback;
        }

        @Override
        public void run() {
            if (this.count.decrementAndGet() <= 0) {
                this.finishCallback.run();
            }
        }
    }
}

