/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.FailedRecordProcessor;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.SeekUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public class DefaultAfterRollbackProcessor<K, V>
extends FailedRecordProcessor
implements AfterRollbackProcessor<K, V> {
    private final ThreadLocal<BackOffExecution> backOffs = new ThreadLocal();
    private final ThreadLocal<Long> lastIntervals = new ThreadLocal();
    private final BackOff backOff;
    private KafkaOperations<?, ?> kafkaTemplate;

    public DefaultAfterRollbackProcessor() {
        this(null, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    public DefaultAfterRollbackProcessor(BackOff backOff) {
        this(null, backOff);
    }

    public DefaultAfterRollbackProcessor(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    public DefaultAfterRollbackProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff) {
        this(recoverer, backOff, null, false);
    }

    public DefaultAfterRollbackProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff, @Nullable KafkaOperations<?, ?> kafkaOperations, boolean commitRecovered) {
        super(recoverer, backOff);
        this.kafkaTemplate = kafkaOperations;
        super.setCommitRecovered(commitRecovered);
        this.checkConfig();
        this.backOff = backOff;
    }

    private void checkConfig() {
        Assert.isTrue((!this.isCommitRecovered() || this.kafkaTemplate != null ? 1 : 0) != 0, (String)"A KafkaOperations is required when 'commitRecovered' is true");
    }

    @Override
    public void process(List<ConsumerRecord<K, V>> records, Consumer<K, V> consumer, @Nullable MessageListenerContainer container, Exception exception, boolean recoverable, ContainerProperties.EOSMode eosMode) {
        if (SeekUtils.doSeeks(records, consumer, exception, recoverable, this.getRecoveryStrategy(records, exception), container, this.logger) && this.isCommitRecovered() && this.kafkaTemplate.isTransactional()) {
            ConsumerRecord<?, ?> skipped = records.get(0);
            if (ContainerProperties.EOSMode.V1.equals((Object)eosMode.getMode())) {
                this.kafkaTemplate.sendOffsetsToTransaction(Collections.singletonMap(new TopicPartition(skipped.topic(), skipped.partition()), DefaultAfterRollbackProcessor.createOffsetAndMetadata(container, skipped.offset() + 1L)));
            } else {
                this.kafkaTemplate.sendOffsetsToTransaction(Collections.singletonMap(new TopicPartition(skipped.topic(), skipped.partition()), DefaultAfterRollbackProcessor.createOffsetAndMetadata(container, skipped.offset() + 1L)), consumer.groupMetadata());
            }
        }
        if (!recoverable && this.backOff != null) {
            try {
                ListenerUtils.unrecoverableBackOff(this.backOff, this.backOffs, this.lastIntervals, container);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isProcessInTransaction() {
        return this.isCommitRecovered();
    }

    @Override
    public void clearThreadState() {
        super.clearThreadState();
        this.backOffs.remove();
        this.lastIntervals.remove();
    }

    private static OffsetAndMetadata createOffsetAndMetadata(@Nullable MessageListenerContainer container, long offset) {
        if (container == null) {
            return new OffsetAndMetadata(offset);
        }
        return ListenerUtils.createOffsetAndMetadata(container, offset);
    }
}

