/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.kafka.config.MethodKafkaListenerEndpoint;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.EndpointCustomizer;
import org.springframework.kafka.retrytopic.EndpointHandlerMethod;
import org.springframework.kafka.retrytopic.RetryTopicNamesProviderFactory;
import org.springframework.kafka.support.TopicPartitionOffset;

public class EndpointCustomizerFactory {
    private final DestinationTopic.Properties destinationProperties;
    private final EndpointHandlerMethod beanMethod;
    private final BeanFactory beanFactory;
    private final RetryTopicNamesProviderFactory retryTopicNamesProviderFactory;

    EndpointCustomizerFactory(DestinationTopic.Properties destinationProperties, EndpointHandlerMethod beanMethod, BeanFactory beanFactory, RetryTopicNamesProviderFactory retryTopicNamesProviderFactory) {
        this.destinationProperties = destinationProperties;
        this.beanMethod = beanMethod;
        this.beanFactory = beanFactory;
        this.retryTopicNamesProviderFactory = retryTopicNamesProviderFactory;
    }

    public final EndpointCustomizer createEndpointCustomizer() {
        return this.addSuffixesAndMethod(this.destinationProperties, this.beanMethod.resolveBean(this.beanFactory), this.beanMethod.getMethod());
    }

    protected EndpointCustomizer addSuffixesAndMethod(DestinationTopic.Properties properties, Object bean, Method method) {
        RetryTopicNamesProviderFactory.RetryTopicNamesProvider namesProvider = this.retryTopicNamesProviderFactory.createRetryTopicNamesProvider(properties);
        return endpoint -> {
            Collection<EndpointCustomizer.TopicNamesHolder> topics = this.customizeAndRegisterTopics(namesProvider, endpoint);
            endpoint.setId(namesProvider.getEndpointId(endpoint));
            endpoint.setGroupId(namesProvider.getGroupId(endpoint));
            endpoint.setTopics((String[])topics.stream().map(EndpointCustomizer.TopicNamesHolder::getCustomizedTopic).toArray(String[]::new));
            endpoint.setClientIdPrefix(namesProvider.getClientIdPrefix(endpoint));
            endpoint.setGroup(namesProvider.getGroup(endpoint));
            endpoint.setBean(bean);
            endpoint.setMethod(method);
            return topics;
        };
    }

    protected Collection<EndpointCustomizer.TopicNamesHolder> customizeAndRegisterTopics(RetryTopicNamesProviderFactory.RetryTopicNamesProvider namesProvider, MethodKafkaListenerEndpoint<?, ?> endpoint) {
        return this.getTopics(endpoint).stream().map(topic -> new EndpointCustomizer.TopicNamesHolder((String)topic, namesProvider.getTopicName((String)topic))).collect(Collectors.toList());
    }

    private Collection<String> getTopics(MethodKafkaListenerEndpoint<?, ?> endpoint) {
        TopicPartitionOffset[] topicPartitionsToAssign;
        Collection topics = endpoint.getTopics();
        if (topics.isEmpty() && (topicPartitionsToAssign = endpoint.getTopicPartitionsToAssign()) != null && topicPartitionsToAssign.length > 0) {
            topics = Arrays.stream(topicPartitionsToAssign).map(TopicPartitionOffset::getTopic).collect(Collectors.toList());
        }
        if (topics.isEmpty()) {
            throw new IllegalStateException(String.format("No topics were provided for RetryTopicConfiguration for method %s in class %s.", endpoint.getMethod().getName(), endpoint.getBean().getClass().getSimpleName()));
        }
        return topics;
    }
}

