/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.util.Assert;

public class CompositeRecordInterceptor<K, V>
implements RecordInterceptor<K, V> {
    private final Collection<RecordInterceptor<K, V>> delegates = new ArrayList<RecordInterceptor<K, V>>();

    @SafeVarargs
    public CompositeRecordInterceptor(RecordInterceptor<K, V> ... delegates) {
        Assert.notNull(delegates, (String)"'delegates' cannot be null");
        Assert.noNullElements((Object[])delegates, (String)"'delegates' cannot have null entries");
        this.delegates.addAll(Arrays.asList(delegates));
    }

    @Override
    public ConsumerRecord<K, V> intercept(ConsumerRecord<K, V> record) {
        ConsumerRecord<K, V> recordToIntercept = record;
        for (RecordInterceptor<K, V> delegate : this.delegates) {
            recordToIntercept = delegate.intercept(recordToIntercept);
        }
        return recordToIntercept;
    }

    @Override
    public void success(ConsumerRecord<K, V> record) {
        this.delegates.forEach(del -> del.success(record));
    }

    @Override
    public void failure(ConsumerRecord<K, V> record, Exception exception) {
        this.delegates.forEach(del -> del.failure(record, exception));
    }
}

