/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.transaction;

import java.time.Duration;
import org.springframework.kafka.core.KafkaResourceHolder;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.core.ProducerFactoryUtils;
import org.springframework.kafka.transaction.KafkaAwareTransactionManager;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class KafkaTransactionManager<K, V>
extends AbstractPlatformTransactionManager
implements KafkaAwareTransactionManager<K, V> {
    private static final String UNCHECKED = "unchecked";
    private final ProducerFactory<K, V> producerFactory;
    private String transactionIdPrefix;
    private Duration closeTimeout = ProducerFactoryUtils.DEFAULT_CLOSE_TIMEOUT;

    public KafkaTransactionManager(ProducerFactory<K, V> producerFactory) {
        Assert.notNull(producerFactory, (String)"The 'ProducerFactory' cannot be null");
        Assert.isTrue((boolean)producerFactory.transactionCapable(), (String)"The 'ProducerFactory' must support transactions");
        this.setTransactionSynchronization(2);
        this.producerFactory = producerFactory;
    }

    public void setTransactionIdPrefix(String transactionIdPrefix) {
        this.transactionIdPrefix = transactionIdPrefix;
    }

    @Override
    public ProducerFactory<K, V> getProducerFactory() {
        return this.producerFactory;
    }

    public void setCloseTimeout(Duration closeTimeout) {
        Assert.notNull((Object)closeTimeout, (String)"'closeTimeout' cannot be null");
        this.closeTimeout = closeTimeout;
    }

    @Deprecated
    public Object getResourceFactory() {
        return this.getProducerFactory();
    }

    protected Object doGetTransaction() {
        KafkaTransactionObject txObject = new KafkaTransactionObject();
        txObject.setResourceHolder((KafkaResourceHolder)((Object)TransactionSynchronizationManager.getResource(this.getProducerFactory())));
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        KafkaTransactionObject txObject = (KafkaTransactionObject)transaction;
        return txObject.getResourceHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("Apache Kafka does not support an isolation level concept");
        }
        KafkaTransactionObject txObject = (KafkaTransactionObject)transaction;
        KafkaResourceHolder<K, V> resourceHolder = null;
        try {
            resourceHolder = ProducerFactoryUtils.getTransactionalResourceHolder(this.getProducerFactory(), this.transactionIdPrefix, this.closeTimeout);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created Kafka transaction on producer [" + resourceHolder.getProducer() + "]"));
            }
            txObject.setResourceHolder(resourceHolder);
            txObject.getResourceHolder().setSynchronizedWithTransaction(true);
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                txObject.getResourceHolder().setTimeoutInSeconds(timeout);
            }
        }
        catch (Exception ex) {
            if (resourceHolder != null) {
                ProducerFactoryUtils.releaseResources(resourceHolder);
            }
            throw new CannotCreateTransactionException("Could not create Kafka transaction", (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        KafkaTransactionObject txObject = (KafkaTransactionObject)transaction;
        txObject.setResourceHolder(null);
        return TransactionSynchronizationManager.unbindResource(this.getProducerFactory());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        KafkaResourceHolder producerHolder = (KafkaResourceHolder)((Object)suspendedResources);
        TransactionSynchronizationManager.bindResource(this.getProducerFactory(), (Object)((Object)producerHolder));
    }

    protected void doCommit(DefaultTransactionStatus status) {
        KafkaTransactionObject txObject = (KafkaTransactionObject)status.getTransaction();
        KafkaResourceHolder resourceHolder = txObject.getResourceHolder();
        resourceHolder.commit();
    }

    protected void doRollback(DefaultTransactionStatus status) {
        KafkaTransactionObject txObject = (KafkaTransactionObject)status.getTransaction();
        KafkaResourceHolder resourceHolder = txObject.getResourceHolder();
        resourceHolder.rollback();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        KafkaTransactionObject txObject = (KafkaTransactionObject)status.getTransaction();
        txObject.getResourceHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        KafkaTransactionObject txObject = (KafkaTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource(this.getProducerFactory());
        txObject.getResourceHolder().close();
        txObject.getResourceHolder().clear();
    }

    private static class KafkaTransactionObject<K, V>
    implements SmartTransactionObject {
        private KafkaResourceHolder<K, V> resourceHolder;

        KafkaTransactionObject() {
        }

        public void setResourceHolder(KafkaResourceHolder<K, V> resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        public KafkaResourceHolder<K, V> getResourceHolder() {
            return this.resourceHolder;
        }

        public boolean isRollbackOnly() {
            return this.resourceHolder.isRollbackOnly();
        }

        public void flush() {
        }
    }
}

