/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Deprecated
public class ErrorHandlingDeserializer<T>
implements Deserializer<T> {
    public static final String KEY_DESERIALIZER_CLASS = "spring.deserializer.key.delegate.class";
    public static final String VALUE_DESERIALIZER_CLASS = "spring.deserializer.value.delegate.class";
    private Deserializer<T> delegate;
    private boolean isForKey;

    public ErrorHandlingDeserializer() {
    }

    public ErrorHandlingDeserializer(Deserializer<T> delegate) {
        this.delegate = this.setupDelegate(delegate);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (isKey && configs.containsKey(KEY_DESERIALIZER_CLASS)) {
            try {
                Object value = configs.get(KEY_DESERIALIZER_CLASS);
                Class clazz = value instanceof Class ? (Class)value : ClassUtils.forName((String)((String)value), null);
                this.delegate = this.setupDelegate(clazz.newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                throw new IllegalStateException(e);
            }
        }
        if (!isKey && configs.containsKey(VALUE_DESERIALIZER_CLASS)) {
            try {
                Object value = configs.get(VALUE_DESERIALIZER_CLASS);
                Class clazz = value instanceof Class ? (Class)value : ClassUtils.forName((String)((String)value), null);
                this.delegate = this.setupDelegate(clazz.newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                throw new IllegalStateException(e);
            }
        }
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"No delegate deserializer configured");
        this.delegate.configure(configs, isKey);
        this.isForKey = isKey;
    }

    private Deserializer<T> setupDelegate(Object delegate) {
        Assert.isInstanceOf(Deserializer.class, (Object)delegate, (String)"'delegate' must be a 'Deserializer', not a ");
        return (Deserializer)delegate;
    }

    public T deserialize(String topic, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, data);
        }
        catch (Exception e) {
            return this.deserializationException(null, data, e);
        }
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        try {
            return (T)this.delegate.deserialize(topic, headers, data);
        }
        catch (Exception e) {
            return this.deserializationException(headers, data, e);
        }
    }

    public void close() {
        this.delegate.close();
    }

    private T deserializationException(Headers headers, byte[] data, Exception e) {
        AtomicReference<DeserializationException> reference = new AtomicReference<DeserializationException>(new DeserializationException("Failed to deserialize", headers, data, this.isForKey, e));
        return (T)((Object)reference.get());
    }
}

