/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.support.JacksonUtils;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JsonSerde<T>
implements Serde<T> {
    private final JsonSerializer<T> jsonSerializer;
    private final JsonDeserializer<T> jsonDeserializer;

    public JsonSerde() {
        this((ObjectMapper)null);
    }

    public JsonSerde(Class<? super T> targetType) {
        this(targetType, null);
    }

    public JsonSerde(ObjectMapper objectMapper) {
        this(null, objectMapper);
    }

    public JsonSerde(@Nullable Class<? super T> targetTypeArg, @Nullable ObjectMapper objectMapperArg) {
        ObjectMapper objectMapper = objectMapperArg;
        Class targetType = targetTypeArg;
        if (objectMapper == null) {
            objectMapper = JacksonUtils.enhancedObjectMapper();
        }
        this.jsonSerializer = new JsonSerializer(objectMapper);
        if (targetType == null) {
            targetType = ResolvableType.forClass(this.getClass()).getSuperType().resolveGeneric(new int[]{0});
        }
        this.jsonDeserializer = new JsonDeserializer<T>(targetType, objectMapper);
    }

    public JsonSerde(JsonSerializer<T> jsonSerializer, JsonDeserializer<T> jsonDeserializer) {
        Assert.notNull(jsonSerializer, (String)"'jsonSerializer' must not be null.");
        Assert.notNull(jsonDeserializer, (String)"'jsonDeserializer' must not be null.");
        this.jsonSerializer = jsonSerializer;
        this.jsonDeserializer = jsonDeserializer;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.jsonSerializer.configure(configs, isKey);
        this.jsonDeserializer.configure(configs, isKey);
    }

    public void close() {
        this.jsonSerializer.close();
        this.jsonDeserializer.close();
    }

    public Serializer<T> serializer() {
        return this.jsonSerializer;
    }

    public Deserializer<T> deserializer() {
        return this.jsonDeserializer;
    }

    @Deprecated
    public JsonSerde<T> setUseTypeMapperForKey(boolean isKey) {
        return this.forKeys();
    }

    public JsonSerde<T> forKeys() {
        this.jsonSerializer.forKeys();
        this.jsonDeserializer.forKeys();
        return this;
    }

    public JsonSerde<T> noTypeInfo() {
        this.jsonSerializer.noTypeInfo();
        return this;
    }

    public JsonSerde<T> dontRemoveTypeHeaders() {
        this.jsonDeserializer.dontRemoveTypeHeaders();
        return this;
    }

    public JsonSerde<T> ignoreTypeHeaders() {
        this.jsonDeserializer.ignoreTypeHeaders();
        return this;
    }

    public JsonSerde<T> typeMapper(Jackson2JavaTypeMapper mapper) {
        this.jsonSerializer.setTypeMapper(mapper);
        this.jsonDeserializer.setTypeMapper(mapper);
        return this;
    }
}

