/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareBatchErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public class SeekToCurrentBatchErrorHandler
implements ContainerAwareBatchErrorHandler {
    private final ThreadLocal<BackOffExecution> backOffs = new ThreadLocal();
    private final ThreadLocal<Long> lastInterval = new ThreadLocal();
    private BackOff backOff;

    public void setBackOff(BackOff backOff) {
        this.backOff = backOff;
    }

    @Override
    public void handle(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container) {
        data.partitions().stream().collect(Collectors.toMap(tp -> tp, tp -> ((ConsumerRecord)data.records(tp).get(0)).offset(), (u, v) -> (long)v, LinkedHashMap::new)).forEach((arg_0, arg_1) -> consumer.seek(arg_0, arg_1));
        if (this.backOff != null) {
            Long interval;
            BackOffExecution backOffExecution = this.backOffs.get();
            if (backOffExecution == null) {
                backOffExecution = this.backOff.start();
                this.backOffs.set(backOffExecution);
            }
            if ((interval = Long.valueOf(backOffExecution.nextBackOff())) == -1L && (interval = this.lastInterval.get()) == null) {
                interval = 0L;
            }
            this.lastInterval.set(interval);
            if (interval > 0L) {
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new KafkaException("Seek to current after exception", thrownException);
    }

    @Override
    public void clearThreadState() {
        this.backOffs.remove();
        this.lastInterval.remove();
    }
}

