/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.kafka.listener.ConsumerProperties;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class ContainerProperties
extends ConsumerProperties {
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 10000L;
    public static final int DEFAULT_MONITOR_INTERVAL = 30;
    public static final float DEFAULT_NO_POLL_THRESHOLD = 3.0f;
    private static final Duration DEFAULT_CONSUMER_START_TIMEOUT = Duration.ofSeconds(30L);
    private final Map<String, String> micrometerTags = new HashMap<String, String>();
    private AckMode ackMode = AckMode.BATCH;
    private int ackCount;
    private long ackTime;
    private Object messageListener;
    private AsyncListenableTaskExecutor consumerTaskExecutor;
    private long shutdownTimeout = 10000L;
    private boolean ackOnError = false;
    private Long idleEventInterval;
    private PlatformTransactionManager transactionManager;
    private int monitorInterval = 30;
    private TaskScheduler scheduler;
    private float noPollThreshold = 3.0f;
    private boolean logContainerConfig;
    private boolean missingTopicsFatal = false;
    private long idleBetweenPolls;
    private boolean micrometerEnabled = true;
    private Duration consumerStartTimout = DEFAULT_CONSUMER_START_TIMEOUT;
    private boolean subBatchPerPartition;
    private AssignmentCommitOption assignmentCommitOption = AssignmentCommitOption.ALWAYS;

    public ContainerProperties(String ... topics) {
        super(topics);
    }

    public ContainerProperties(Pattern topicPattern) {
        super(topicPattern);
    }

    @Deprecated
    public ContainerProperties(TopicPartitionInitialOffset ... topicPartitions) {
        super(ContainerProperties.convertTopicPartitions(topicPartitions));
    }

    @Deprecated
    private static TopicPartitionOffset[] convertTopicPartitions(TopicPartitionInitialOffset[] topicPartitions) {
        Assert.notEmpty((Object[])topicPartitions, (String)"An array of topicPartitions must be provided");
        return (TopicPartitionOffset[])Arrays.stream(topicPartitions).map(TopicPartitionInitialOffset::toTPO).toArray(TopicPartitionOffset[]::new);
    }

    public ContainerProperties(TopicPartitionOffset ... topicPartitions) {
        super(topicPartitions);
    }

    public void setMessageListener(Object messageListener) {
        this.messageListener = messageListener;
    }

    public void setAckMode(AckMode ackMode) {
        Assert.notNull((Object)((Object)ackMode), (String)"'ackMode' cannot be null");
        this.ackMode = ackMode;
    }

    public void setAckCount(int count) {
        Assert.state((count > 0 ? 1 : 0) != 0, (String)"'ackCount' must be > 0");
        this.ackCount = count;
    }

    public void setAckTime(long ackTime) {
        Assert.state((ackTime > 0L ? 1 : 0) != 0, (String)"'ackTime' must be > 0");
        this.ackTime = ackTime;
    }

    public void setConsumerTaskExecutor(AsyncListenableTaskExecutor consumerTaskExecutor) {
        this.consumerTaskExecutor = consumerTaskExecutor;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    @Override
    public void setSyncCommitTimeout(@Nullable Duration syncCommitTimeout) {
        super.setSyncCommitTimeout(syncCommitTimeout);
    }

    public void setIdleEventInterval(Long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setAckOnError(boolean ackOnError) {
        this.ackOnError = ackOnError;
    }

    @Deprecated
    @Nullable
    public TopicPartitionInitialOffset[] getTopicPartitions() {
        TopicPartitionOffset[] topicPartitionsToAssign = this.getTopicPartitionsToAssign();
        return topicPartitionsToAssign != null ? (TopicPartitionInitialOffset[])Arrays.stream(topicPartitionsToAssign).map(TopicPartitionInitialOffset::fromTPO).toArray(TopicPartitionInitialOffset[]::new) : null;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public int getAckCount() {
        return this.ackCount;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public Object getMessageListener() {
        return this.messageListener;
    }

    public AsyncListenableTaskExecutor getConsumerTaskExecutor() {
        return this.consumerTaskExecutor;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public Long getIdleEventInterval() {
        return this.idleEventInterval;
    }

    public boolean isAckOnError() {
        return this.ackOnError && !AckMode.MANUAL_IMMEDIATE.equals((Object)this.ackMode) && !AckMode.MANUAL.equals((Object)this.ackMode);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public float getNoPollThreshold() {
        return this.noPollThreshold;
    }

    public void setNoPollThreshold(float noPollThreshold) {
        this.noPollThreshold = noPollThreshold;
    }

    public boolean isLogContainerConfig() {
        return this.logContainerConfig;
    }

    public void setLogContainerConfig(boolean logContainerConfig) {
        this.logContainerConfig = logContainerConfig;
    }

    public boolean isMissingTopicsFatal() {
        return this.missingTopicsFatal;
    }

    public void setMissingTopicsFatal(boolean missingTopicsFatal) {
        this.missingTopicsFatal = missingTopicsFatal;
    }

    @Deprecated
    public Properties getConsumerProperties() {
        return this.getKafkaConsumerProperties();
    }

    @Deprecated
    public void setConsumerProperties(Properties consumerProperties) {
        this.setKafkaConsumerProperties(consumerProperties);
    }

    public void setIdleBetweenPolls(long idleBetweenPolls) {
        this.idleBetweenPolls = idleBetweenPolls;
    }

    public long getIdleBetweenPolls() {
        return this.idleBetweenPolls;
    }

    public boolean isMicrometerEnabled() {
        return this.micrometerEnabled;
    }

    public void setMicrometerEnabled(boolean micrometerEnabled) {
        this.micrometerEnabled = micrometerEnabled;
    }

    public void setMicrometerTags(Map<String, String> tags) {
        if (tags != null) {
            this.micrometerTags.putAll(tags);
        }
    }

    public Map<String, String> getMicrometerTags() {
        return Collections.unmodifiableMap(this.micrometerTags);
    }

    public Duration getConsumerStartTimout() {
        return this.consumerStartTimout;
    }

    public void setConsumerStartTimout(Duration consumerStartTimout) {
        Assert.notNull((Object)consumerStartTimout, (String)"'consumerStartTimout' cannot be null");
        this.consumerStartTimout = consumerStartTimout;
    }

    public boolean isSubBatchPerPartition() {
        return this.subBatchPerPartition;
    }

    public void setSubBatchPerPartition(boolean subBatchPerPartition) {
        this.subBatchPerPartition = subBatchPerPartition;
    }

    public AssignmentCommitOption getAssignmentCommitOption() {
        return this.assignmentCommitOption;
    }

    public void setAssignmentCommitOption(AssignmentCommitOption assignmentCommitOption) {
        Assert.notNull((Object)((Object)assignmentCommitOption), (String)"'assignmentCommitOption' cannot be null");
        this.assignmentCommitOption = assignmentCommitOption;
    }

    @Override
    public String toString() {
        return "ContainerProperties [" + this.renderProperties() + ", ackMode=" + (Object)((Object)this.ackMode) + ", ackCount=" + this.ackCount + ", ackTime=" + this.ackTime + ", messageListener=" + this.messageListener + (this.consumerTaskExecutor != null ? ", consumerTaskExecutor=" + this.consumerTaskExecutor : "") + ", shutdownTimeout=" + this.shutdownTimeout + ", ackOnError=" + this.ackOnError + ", idleEventInterval=" + (this.idleEventInterval == null ? "not enabled" : this.idleEventInterval) + (this.transactionManager != null ? ", transactionManager=" + this.transactionManager : "") + ", monitorInterval=" + this.monitorInterval + (this.scheduler != null ? ", scheduler=" + this.scheduler : "") + ", noPollThreshold=" + this.noPollThreshold + ", subBatchPerPartition=" + this.subBatchPerPartition + "]";
    }

    public static enum AssignmentCommitOption {
        ALWAYS,
        NEVER,
        LATEST_ONLY,
        LATEST_ONLY_NO_TX;

    }

    public static enum AckMode {
        RECORD,
        BATCH,
        TIME,
        COUNT,
        COUNT_TIME,
        MANUAL,
        MANUAL_IMMEDIATE;

    }
}

