/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.BatchAcknowledgingMessageListener;
import org.springframework.kafka.listener.adapter.AbstractFilteringMessageListener;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.support.Acknowledgment;

public class FilteringBatchAcknowledgingMessageListenerAdapter<K, V>
extends AbstractFilteringMessageListener<K, V, BatchAcknowledgingMessageListener<K, V>>
implements BatchAcknowledgingMessageListener<K, V> {
    private final boolean ackDiscarded;

    public FilteringBatchAcknowledgingMessageListenerAdapter(BatchAcknowledgingMessageListener<K, V> delegate, RecordFilterStrategy<K, V> recordFilterStrategy) {
        this(delegate, recordFilterStrategy, false);
    }

    public FilteringBatchAcknowledgingMessageListenerAdapter(BatchAcknowledgingMessageListener<K, V> delegate, RecordFilterStrategy<K, V> recordFilterStrategy, boolean ackDiscarded) {
        super(delegate, recordFilterStrategy);
        this.ackDiscarded = ackDiscarded;
    }

    @Override
    public void onMessage(List<ConsumerRecord<K, V>> consumerRecords, Acknowledgment acknowledgment) {
        Iterator<ConsumerRecord<K, V>> iterator = consumerRecords.iterator();
        while (iterator.hasNext()) {
            if (!this.filter(iterator.next())) continue;
            iterator.remove();
        }
        if (consumerRecords.size() > 0 || !this.ackDiscarded) {
            ((BatchAcknowledgingMessageListener)this.delegate).onMessage(consumerRecords, acknowledgment);
        } else {
            acknowledgment.acknowledge();
        }
    }
}

