/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.core.ClientIdSuffixAware;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.event.ListenerContainerIdleEvent;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchErrorHandler;
import org.springframework.kafka.listener.BatchLoggingErrorHandler;
import org.springframework.kafka.listener.BatchMessageListener;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.GenericAcknowledgingMessageListener;
import org.springframework.kafka.listener.GenericErrorHandler;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.KafkaMessageListenerContainer;
import org.springframework.kafka.listener.LoggingErrorHandler;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.config.ContainerProperties;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class KafkaMessageListenerContainer<K, V>
extends AbstractMessageListenerContainer<K, V> {
    private final ConsumerFactory<K, V> consumerFactory;
    private final TopicPartitionInitialOffset[] topicPartitions;
    private ListenerConsumer listenerConsumer;
    private ListenableFuture<?> listenerConsumerFuture;
    private GenericMessageListener<?> listener;
    private GenericAcknowledgingMessageListener<?> acknowledgingMessageListener;
    private String clientIdSuffix;

    public KafkaMessageListenerContainer(ConsumerFactory<K, V> consumerFactory, ContainerProperties containerProperties) {
        this(consumerFactory, containerProperties, null);
    }

    public KafkaMessageListenerContainer(ConsumerFactory<K, V> consumerFactory, ContainerProperties containerProperties, TopicPartitionInitialOffset ... topicPartitions) {
        super(containerProperties);
        Assert.notNull(consumerFactory, (String)"A ConsumerFactory must be provided");
        this.consumerFactory = consumerFactory;
        this.topicPartitions = topicPartitions != null ? Arrays.copyOf(topicPartitions, topicPartitions.length) : containerProperties.getTopicPartitions();
    }

    public void setClientIdSuffix(String clientIdSuffix) {
        this.clientIdSuffix = clientIdSuffix;
    }

    public Collection<TopicPartition> getAssignedPartitions() {
        if (this.listenerConsumer.definedPartitions != null) {
            return Collections.unmodifiableCollection(this.listenerConsumer.definedPartitions.keySet());
        }
        if (this.listenerConsumer.assignedPartitions != null) {
            return Collections.unmodifiableCollection(this.listenerConsumer.assignedPartitions);
        }
        return null;
    }

    @Override
    protected void doStart() {
        Object messageListener;
        if (this.isRunning()) {
            return;
        }
        ContainerProperties containerProperties = this.getContainerProperties();
        if (!this.consumerFactory.isAutoCommit()) {
            AbstractMessageListenerContainer.AckMode ackMode = containerProperties.getAckMode();
            if (ackMode.equals((Object)AbstractMessageListenerContainer.AckMode.COUNT) || ackMode.equals((Object)AbstractMessageListenerContainer.AckMode.COUNT_TIME)) {
                Assert.state((containerProperties.getAckCount() > 0 ? 1 : 0) != 0, (String)"'ackCount' must be > 0");
            }
            if ((ackMode.equals((Object)AbstractMessageListenerContainer.AckMode.TIME) || ackMode.equals((Object)AbstractMessageListenerContainer.AckMode.COUNT_TIME)) && containerProperties.getAckTime() == 0L) {
                containerProperties.setAckTime(5000L);
            }
        }
        Assert.state(((messageListener = containerProperties.getMessageListener()) != null ? 1 : 0) != 0, (String)"A MessageListener is required");
        if (messageListener instanceof GenericAcknowledgingMessageListener) {
            this.acknowledgingMessageListener = (GenericAcknowledgingMessageListener)messageListener;
        } else if (messageListener instanceof GenericMessageListener) {
            this.listener = (GenericMessageListener)messageListener;
        } else {
            throw new IllegalStateException("messageListener must be 'MessageListener' or 'AcknowledgingMessageListener', not " + messageListener.getClass().getName());
        }
        if (containerProperties.getConsumerTaskExecutor() == null) {
            SimpleAsyncTaskExecutor consumerExecutor = new SimpleAsyncTaskExecutor((this.getBeanName() == null ? "" : this.getBeanName()) + "-C-");
            containerProperties.setConsumerTaskExecutor((AsyncListenableTaskExecutor)consumerExecutor);
        }
        if (containerProperties.getListenerTaskExecutor() == null) {
            SimpleAsyncTaskExecutor listenerExecutor = new SimpleAsyncTaskExecutor((this.getBeanName() == null ? "" : this.getBeanName()) + "-L-");
            containerProperties.setListenerTaskExecutor((AsyncListenableTaskExecutor)listenerExecutor);
        }
        this.listenerConsumer = new ListenerConsumer(this.listener, this.acknowledgingMessageListener);
        this.setRunning(true);
        this.listenerConsumerFuture = containerProperties.getConsumerTaskExecutor().submitListenable((Runnable)((Object)this.listenerConsumer));
    }

    @Override
    protected void doStop(final Runnable callback) {
        if (this.isRunning()) {
            this.listenerConsumerFuture.addCallback((ListenableFutureCallback)new ListenableFutureCallback<Object>(){

                public void onFailure(Throwable e) {
                    KafkaMessageListenerContainer.this.logger.error((Object)"Error while stopping the container: ", e);
                    if (callback != null) {
                        callback.run();
                    }
                }

                public void onSuccess(Object result) {
                    if (KafkaMessageListenerContainer.this.logger.isDebugEnabled()) {
                        KafkaMessageListenerContainer.this.logger.debug((Object)(KafkaMessageListenerContainer.this + " stopped normally"));
                    }
                    if (callback != null) {
                        callback.run();
                    }
                }
            });
            this.setRunning(false);
            this.listenerConsumer.consumer.wakeup();
        }
    }

    private void publishIdleContainerEvent(long idleTime) {
        if (this.getApplicationEventPublisher() != null) {
            this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new ListenerContainerIdleEvent(this, idleTime, this.getBeanName(), this.getAssignedPartitions()));
        }
    }

    public String toString() {
        return "KafkaMessageListenerContainer [id=" + this.getBeanName() + (this.clientIdSuffix != null ? ", clientIndex=" + this.clientIdSuffix : "") + ", topicPartitions=" + this.getAssignedPartitions() + "]";
    }

    private static final class OffsetMetadata {
        private final Long offset;
        private final boolean relativeToCurrent;

        OffsetMetadata(Long offset, boolean relativeToCurrent) {
            this.offset = offset;
            this.relativeToCurrent = relativeToCurrent;
        }
    }

    private static final class LoggingCommitCallback
    implements OffsetCommitCallback {
        private static final Log logger = LogFactory.getLog(LoggingCommitCallback.class);

        LoggingCommitCallback() {
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception != null) {
                logger.error((Object)("Commit failed for " + offsets), (Throwable)exception);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Commits for " + offsets + " completed"));
            }
        }
    }

    private final class ListenerConsumer
    implements SchedulingAwareRunnable,
    ConsumerSeekAware.ConsumerSeekCallback {
        private final Log logger = LogFactory.getLog(ListenerConsumer.class);
        private final Object theListener;
        private final ContainerProperties containerProperties = KafkaMessageListenerContainer.this.getContainerProperties();
        private final OffsetCommitCallback commitCallback = this.containerProperties.getCommitCallback() != null ? this.containerProperties.getCommitCallback() : new LoggingCommitCallback();
        private final Consumer<K, V> consumer;
        private final Map<String, Map<Integer, Long>> offsets = new HashMap<String, Map<Integer, Long>>();
        private final MessageListener<K, V> listener;
        private final AcknowledgingMessageListener<K, V> acknowledgingMessageListener;
        private final BatchMessageListener<K, V> batchListener;
        private final BatchAcknowledgingMessageListener<K, V> batchAcknowledgingMessageListener;
        private final boolean isBatchListener;
        private final boolean autoCommit = KafkaMessageListenerContainer.access$300(KafkaMessageListenerContainer.this).isAutoCommit();
        private final boolean isManualAck = this.containerProperties.getAckMode().equals((Object)AbstractMessageListenerContainer.AckMode.MANUAL);
        private final boolean isManualImmediateAck = this.containerProperties.getAckMode().equals((Object)AbstractMessageListenerContainer.AckMode.MANUAL_IMMEDIATE);
        private final boolean isAnyManualAck = this.isManualAck || this.isManualImmediateAck;
        private final boolean isRecordAck = this.containerProperties.getAckMode().equals((Object)AbstractMessageListenerContainer.AckMode.RECORD);
        private final boolean isBatchAck = this.containerProperties.getAckMode().equals((Object)AbstractMessageListenerContainer.AckMode.BATCH);
        private final BlockingQueue<ConsumerRecords<K, V>> recordsToProcess = new LinkedBlockingQueue(this.containerProperties.getQueueDepth());
        private final BlockingQueue<ConsumerRecord<K, V>> acks = new LinkedBlockingQueue();
        private final BlockingQueue<TopicPartitionInitialOffset> seeks = new LinkedBlockingQueue<TopicPartitionInitialOffset>();
        private final ErrorHandler errorHandler;
        private final BatchErrorHandler batchErrorHandler;
        private volatile Map<TopicPartition, OffsetMetadata> definedPartitions;
        private ConsumerRecords<K, V> unsent;
        private volatile Collection<TopicPartition> assignedPartitions;
        private int count;
        private volatile org.springframework.kafka.listener.KafkaMessageListenerContainer$ListenerConsumer.ListenerInvoker invoker;
        private long last;
        private volatile Future<?> listenerInvokerFuture;
        private boolean paused;

        ListenerConsumer(GenericMessageListener<?> listener, GenericAcknowledgingMessageListener<?> ackListener) {
            Assert.state((!this.isAnyManualAck || !this.autoCommit ? 1 : 0) != 0, (String)("Consumer cannot be configured for auto commit for ackMode " + (Object)((Object)this.containerProperties.getAckMode())));
            Consumer consumer = KafkaMessageListenerContainer.this.consumerFactory instanceof ClientIdSuffixAware ? ((ClientIdSuffixAware)((Object)KafkaMessageListenerContainer.this.consumerFactory)).createConsumer(KafkaMessageListenerContainer.this.clientIdSuffix) : KafkaMessageListenerContainer.this.consumerFactory.createConsumer();
            this.theListener = listener == null ? ackListener : listener;
            ConsumerRebalanceListener rebalanceListener = this.createRebalanceListener(consumer);
            if (KafkaMessageListenerContainer.this.topicPartitions == null) {
                if (this.containerProperties.getTopicPattern() != null) {
                    consumer.subscribe(this.containerProperties.getTopicPattern(), rebalanceListener);
                } else {
                    consumer.subscribe(Arrays.asList(this.containerProperties.getTopics()), rebalanceListener);
                }
            } else {
                List<TopicPartitionInitialOffset> topicPartitions = Arrays.asList(KafkaMessageListenerContainer.this.topicPartitions);
                this.definedPartitions = new HashMap<TopicPartition, OffsetMetadata>(topicPartitions.size());
                for (TopicPartitionInitialOffset topicPartition : topicPartitions) {
                    this.definedPartitions.put(topicPartition.topicPartition(), new OffsetMetadata(topicPartition.initialOffset(), topicPartition.isRelativeToCurrent()));
                }
                consumer.assign(new ArrayList<TopicPartition>(this.definedPartitions.keySet()));
            }
            this.consumer = consumer;
            GenericErrorHandler<?> errHandler = this.containerProperties.getGenericErrorHandler();
            if (this.theListener instanceof BatchAcknowledgingMessageListener) {
                this.listener = null;
                this.batchListener = null;
                this.acknowledgingMessageListener = null;
                this.batchAcknowledgingMessageListener = (BatchAcknowledgingMessageListener)this.theListener;
                this.isBatchListener = true;
            } else if (this.theListener instanceof AcknowledgingMessageListener) {
                this.listener = null;
                this.acknowledgingMessageListener = (AcknowledgingMessageListener)this.theListener;
                this.batchListener = null;
                this.batchAcknowledgingMessageListener = null;
                this.isBatchListener = false;
            } else if (this.theListener instanceof BatchMessageListener) {
                this.listener = null;
                this.batchListener = (BatchMessageListener)this.theListener;
                this.acknowledgingMessageListener = null;
                this.batchAcknowledgingMessageListener = null;
                this.isBatchListener = true;
            } else if (this.theListener instanceof MessageListener) {
                this.listener = (MessageListener)this.theListener;
                this.batchListener = null;
                this.acknowledgingMessageListener = null;
                this.batchAcknowledgingMessageListener = null;
                this.isBatchListener = false;
            } else {
                throw new IllegalArgumentException("Listener must be one of 'MessageListener', 'BatchMessageListener', 'AcknowledgingMessageListener', 'BatchAcknowledgingMessageListener', not " + this.theListener.getClass().getName());
            }
            if (this.isBatchListener) {
                this.validateErrorHandler(true);
                this.errorHandler = new LoggingErrorHandler();
                this.batchErrorHandler = errHandler == null ? new BatchLoggingErrorHandler() : (BatchErrorHandler)errHandler;
            } else {
                this.validateErrorHandler(false);
                this.errorHandler = errHandler == null ? new LoggingErrorHandler() : (ErrorHandler)errHandler;
                this.batchErrorHandler = new BatchLoggingErrorHandler();
            }
            Assert.state((!this.isBatchListener || !this.isRecordAck ? 1 : 0) != 0, (String)"Cannot use AckMode.RECORD with a batch listener");
        }

        public ConsumerRebalanceListener createRebalanceListener(final Consumer<K, V> consumer) {
            return new ConsumerRebalanceListener(){

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    if (!ListenerConsumer.this.autoCommit) {
                        if (ListenerConsumer.this.logger.isTraceEnabled()) {
                            ListenerConsumer.this.logger.trace((Object)"Received partition revocation notification, and will stop the invoker.");
                        }
                        if (ListenerConsumer.this.listenerInvokerFuture != null) {
                            ListenerConsumer.this.stopInvoker();
                            ListenerConsumer.this.recordsToProcess.clear();
                            ListenerConsumer.this.unsent = null;
                        } else if (!CollectionUtils.isEmpty(partitions)) {
                            ListenerConsumer.this.logger.error((Object)"Invalid state: the invoker was not active, but the consumer had allocated partitions");
                        }
                    } else if (ListenerConsumer.this.logger.isTraceEnabled()) {
                        ListenerConsumer.this.logger.trace((Object)"Received partition revocation notification, but the container is in autocommit mode, so transition will be handled by the consumer");
                    }
                    KafkaMessageListenerContainer.this.getContainerProperties().getConsumerRebalanceListener().onPartitionsRevoked(partitions);
                    ListenerConsumer.this.commitManualAcks();
                }

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    ListenerConsumer.this.assignedPartitions = partitions;
                    if (!ListenerConsumer.this.autoCommit) {
                        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
                        for (TopicPartition partition : partitions) {
                            offsets.put(partition, new OffsetAndMetadata(consumer.position(partition)));
                        }
                        if (ListenerConsumer.this.logger.isDebugEnabled()) {
                            ListenerConsumer.this.logger.debug((Object)("Committing: " + offsets));
                        }
                        if (KafkaMessageListenerContainer.this.getContainerProperties().isSyncCommits()) {
                            ListenerConsumer.this.consumer.commitSync(offsets);
                        } else {
                            ListenerConsumer.this.consumer.commitAsync(offsets, KafkaMessageListenerContainer.this.getContainerProperties().getCommitCallback());
                        }
                    }
                    if (ListenerConsumer.this.theListener instanceof ConsumerSeekAware) {
                        ListenerConsumer.this.seekPartitions(partitions, false);
                    }
                    if (!ListenerConsumer.this.autoCommit && KafkaMessageListenerContainer.this.isRunning() && !CollectionUtils.isEmpty(partitions)) {
                        ListenerConsumer.this.startInvoker();
                    }
                    KafkaMessageListenerContainer.this.getContainerProperties().getConsumerRebalanceListener().onPartitionsAssigned(partitions);
                }
            };
        }

        private void seekPartitions(Collection<TopicPartition> partitions, boolean idle) {
            HashMap<TopicPartition, Long> current = new HashMap<TopicPartition, Long>();
            for (TopicPartition topicPartition : partitions) {
                current.put(topicPartition, this.consumer.position(topicPartition));
            }
            ConsumerSeekAware.ConsumerSeekCallback callback = new ConsumerSeekAware.ConsumerSeekCallback(){

                @Override
                public void seek(String topic, int partition, long offset) {
                    ListenerConsumer.this.consumer.seek(new TopicPartition(topic, partition), offset);
                }
            };
            if (idle) {
                ((ConsumerSeekAware)this.theListener).onIdleContainer(current, callback);
            } else {
                ((ConsumerSeekAware)this.theListener).onPartitionsAssigned(current, callback);
            }
        }

        private void validateErrorHandler(boolean batch) {
            GenericErrorHandler<?> errHandler = this.containerProperties.getGenericErrorHandler();
            if (this.errorHandler == null) {
                return;
            }
            Type[] genericInterfaces = errHandler.getClass().getGenericInterfaces();
            boolean ok = false;
            for (Type t : genericInterfaces) {
                if (t.equals(ErrorHandler.class)) {
                    ok = !batch;
                    break;
                }
                if (!t.equals(BatchErrorHandler.class)) continue;
                ok = batch;
                break;
            }
            Assert.state((boolean)ok, (String)("Error handler is not compatible with the message listener, expecting an instance of " + (batch ? "BatchErrorHandler" : "ErrorHandler") + " not " + errHandler.getClass().getName()));
        }

        private void startInvoker() {
            this.invoker = new ListenerInvoker();
            this.listenerInvokerFuture = this.containerProperties.getListenerTaskExecutor().submit((Runnable)this.invoker);
        }

        public boolean isLongLived() {
            return true;
        }

        public void run() {
            long lastReceive;
            if (this.theListener instanceof ConsumerSeekAware) {
                ((ConsumerSeekAware)this.theListener).registerSeekCallback(this);
            }
            this.count = 0;
            this.last = System.currentTimeMillis();
            if (KafkaMessageListenerContainer.this.isRunning() && this.definedPartitions != null) {
                this.initPartitionsIfNeeded();
                if (!this.autoCommit) {
                    this.startInvoker();
                }
            }
            long lastAlertAt = lastReceive = System.currentTimeMillis();
            while (KafkaMessageListenerContainer.this.isRunning()) {
                try {
                    long now;
                    ConsumerRecords records;
                    if (!this.autoCommit) {
                        this.processCommits();
                    }
                    this.processSeeks();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Polling (paused=" + this.paused + ")..."));
                    }
                    if ((records = this.consumer.poll(this.containerProperties.getPollTimeout())) != null && this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Received: " + records.count() + " records"));
                    }
                    if (records != null && records.count() > 0) {
                        if (this.containerProperties.getIdleEventInterval() != null) {
                            lastReceive = System.currentTimeMillis();
                        }
                        if (this.autoCommit) {
                            this.invokeListener(records);
                        } else if (this.sendToListener(records) && this.assignedPartitions != null) {
                            this.consumer.pause(this.assignedPartitions);
                            this.paused = true;
                            this.unsent = records;
                        }
                    } else if (this.containerProperties.getIdleEventInterval() != null && (now = System.currentTimeMillis()) > lastReceive + this.containerProperties.getIdleEventInterval() && now > lastAlertAt + this.containerProperties.getIdleEventInterval()) {
                        KafkaMessageListenerContainer.this.publishIdleContainerEvent(now - lastReceive);
                        lastAlertAt = now;
                        if (this.theListener instanceof ConsumerSeekAware) {
                            this.seekPartitions(KafkaMessageListenerContainer.this.getAssignedPartitions(), true);
                        }
                    }
                    this.unsent = this.checkPause(this.unsent);
                }
                catch (WakeupException e) {
                    this.unsent = this.checkPause(this.unsent);
                }
                catch (Exception e) {
                    if (this.containerProperties.getGenericErrorHandler() != null) {
                        this.containerProperties.getGenericErrorHandler().handle(e, null);
                        continue;
                    }
                    this.logger.error((Object)"Container exception", (Throwable)e);
                }
            }
            if (this.listenerInvokerFuture != null) {
                this.stopInvoker();
                this.commitManualAcks();
            }
            try {
                this.consumer.unsubscribe();
            }
            catch (WakeupException wakeupException) {
                // empty catch block
            }
            this.consumer.close();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Consumer stopped");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopInvoker() {
            long now = System.currentTimeMillis();
            ((ListenerInvoker)this.invoker).stop();
            long remaining = this.containerProperties.getShutdownTimeout() + now - System.currentTimeMillis();
            try {
                this.listenerInvokerFuture.get(remaining, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                this.logger.error((Object)"Error while shutting down the listener invoker:", (Throwable)e);
            }
            catch (TimeoutException e) {
                this.logger.info((Object)"Invoker timed out while waiting for shutdown and will be canceled.");
                this.listenerInvokerFuture.cancel(true);
            }
            finally {
                this.listenerInvokerFuture = null;
            }
            this.invoker = null;
        }

        private void commitManualAcks() {
            this.processCommits();
            if (this.offsets.size() > 0) {
                this.commitIfNecessary();
            }
        }

        private ConsumerRecords<K, V> checkPause(ConsumerRecords<K, V> unsent) {
            if (this.paused && this.recordsToProcess.size() < this.containerProperties.getQueueDepth()) {
                this.consumer.resume(this.assignedPartitions);
                this.paused = false;
                if (unsent != null) {
                    try {
                        this.sendToListener(unsent);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new KafkaException("Interrupted while sending to listener", e);
                    }
                }
                return null;
            }
            return unsent;
        }

        private boolean sendToListener(ConsumerRecords<K, V> records) throws InterruptedException {
            if (this.containerProperties.isPauseEnabled() && CollectionUtils.isEmpty(this.definedPartitions)) {
                return !this.recordsToProcess.offer(records, this.containerProperties.getPauseAfter(), TimeUnit.MILLISECONDS);
            }
            this.recordsToProcess.put(records);
            return false;
        }

        private void handleAcks() {
            ConsumerRecord record = (ConsumerRecord)this.acks.poll();
            while (record != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Ack: " + record));
                }
                this.processAck(record);
                record = (ConsumerRecord)this.acks.poll();
            }
        }

        private void processAck(ConsumerRecord<K, V> record) {
            if (this.isManualImmediateAck) {
                try {
                    this.ackImmediate(record);
                }
                catch (WakeupException wakeupException) {}
            } else {
                this.addOffset(record);
            }
        }

        private void ackImmediate(ConsumerRecord<K, V> record) {
            Map<TopicPartition, OffsetAndMetadata> commits = Collections.singletonMap(new TopicPartition(record.topic(), record.partition()), new OffsetAndMetadata(record.offset() + 1L));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Committing: " + commits));
            }
            if (this.containerProperties.isSyncCommits()) {
                this.consumer.commitSync(commits);
            } else {
                this.consumer.commitAsync(commits, this.commitCallback);
            }
        }

        private void invokeListener(ConsumerRecords<K, V> records) {
            if (this.isBatchListener) {
                this.invokeBatchListener(records);
            } else {
                this.invokeRecordListener(records);
            }
        }

        private void invokeBatchListener(ConsumerRecords<K, V> records) {
            LinkedList recordList = new LinkedList();
            Iterator iterator = records.iterator();
            while (iterator.hasNext()) {
                recordList.add((ConsumerRecord)iterator.next());
            }
            if (recordList.size() > 0) {
                try {
                    if (this.batchAcknowledgingMessageListener != null) {
                        this.batchAcknowledgingMessageListener.onMessage(recordList, this.isAnyManualAck ? new ConsumerBatchAcknowledgment(recordList, this.isManualImmediateAck) : null);
                    } else {
                        this.batchListener.onMessage(recordList);
                    }
                    if (!this.isAnyManualAck && !this.autoCommit) {
                        for (ConsumerRecord record : this.getHighestOffsetRecords(recordList)) {
                            this.acks.put(record);
                        }
                    }
                }
                catch (Exception e) {
                    if (this.containerProperties.isAckOnError() && !this.autoCommit) {
                        for (ConsumerRecord record : this.getHighestOffsetRecords(recordList)) {
                            this.acks.add(record);
                        }
                    }
                    try {
                        this.batchErrorHandler.handle(e, records);
                    }
                    catch (Exception ee) {
                        this.logger.error((Object)"Error handler threw an exception", (Throwable)ee);
                    }
                    catch (Error er) {
                        this.logger.error((Object)"Error handler threw an error", (Throwable)er);
                        throw er;
                    }
                }
            }
        }

        private void invokeRecordListener(ConsumerRecords<K, V> records) {
            Iterator iterator = records.iterator();
            while (iterator.hasNext() && (this.autoCommit || this.invoker != null && ((ListenerInvoker)this.invoker).active)) {
                ConsumerRecord record = (ConsumerRecord)iterator.next();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Processing " + record));
                }
                try {
                    if (this.acknowledgingMessageListener != null) {
                        this.acknowledgingMessageListener.onMessage(record, this.isAnyManualAck ? new ConsumerAcknowledgment(record, this.isManualImmediateAck) : null);
                    } else {
                        this.listener.onMessage(record);
                    }
                    if (this.isAnyManualAck || this.autoCommit) continue;
                    this.acks.add(record);
                }
                catch (Exception e) {
                    if (this.containerProperties.isAckOnError() && !this.autoCommit) {
                        this.acks.add(record);
                    }
                    try {
                        this.errorHandler.handle(e, record);
                    }
                    catch (Exception ee) {
                        this.logger.error((Object)"Error handler threw an exception", (Throwable)ee);
                    }
                    catch (Error er) {
                        this.logger.error((Object)"Error handler threw an error", (Throwable)er);
                        throw er;
                    }
                }
            }
        }

        private void processCommits() {
            this.handleAcks();
            this.count += this.acks.size();
            AbstractMessageListenerContainer.AckMode ackMode = this.containerProperties.getAckMode();
            if (!this.isManualImmediateAck) {
                boolean countExceeded;
                if (!this.isManualAck) {
                    this.updatePendingOffsets();
                }
                boolean bl = countExceeded = this.count >= this.containerProperties.getAckCount();
                if (this.isManualAck || this.isBatchAck || this.isRecordAck || ackMode.equals((Object)AbstractMessageListenerContainer.AckMode.COUNT) && countExceeded) {
                    if (this.logger.isDebugEnabled() && ackMode.equals((Object)AbstractMessageListenerContainer.AckMode.COUNT)) {
                        this.logger.debug((Object)("Committing in AckMode.COUNT because count " + this.count + " exceeds configured limit of " + this.containerProperties.getAckCount()));
                    }
                    this.commitIfNecessary();
                    this.count = 0;
                } else {
                    boolean elapsed;
                    long now = System.currentTimeMillis();
                    boolean bl2 = elapsed = now - this.last > this.containerProperties.getAckTime();
                    if (ackMode.equals((Object)AbstractMessageListenerContainer.AckMode.TIME) && elapsed) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Committing in AckMode.TIME because time elapsed exceeds configured limit of " + this.containerProperties.getAckTime()));
                        }
                        this.commitIfNecessary();
                        this.last = now;
                    } else if (ackMode.equals((Object)AbstractMessageListenerContainer.AckMode.COUNT_TIME) && (elapsed || countExceeded)) {
                        if (this.logger.isDebugEnabled()) {
                            if (elapsed) {
                                this.logger.debug((Object)("Committing in AckMode.COUNT_TIME because time elapsed exceeds configured limit of " + this.containerProperties.getAckTime()));
                            } else {
                                this.logger.debug((Object)("Committing in AckMode.COUNT_TIME because count " + this.count + " exceeds configured limit of" + this.containerProperties.getAckCount()));
                            }
                        }
                        this.commitIfNecessary();
                        this.last = now;
                        this.count = 0;
                    }
                }
            }
        }

        private void processSeeks() {
            TopicPartitionInitialOffset offset = (TopicPartitionInitialOffset)this.seeks.poll();
            while (offset != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Seek: " + offset));
                }
                try {
                    this.consumer.seek(offset.topicPartition(), offset.initialOffset().longValue());
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception while seeking " + offset), (Throwable)e);
                }
                offset = (TopicPartitionInitialOffset)this.seeks.poll();
            }
        }

        private void initPartitionsIfNeeded() {
            for (Map.Entry<TopicPartition, OffsetMetadata> entry : this.definedPartitions.entrySet()) {
                TopicPartition topicPartition = entry.getKey();
                OffsetMetadata metadata = entry.getValue();
                Long offset = metadata.offset;
                if (offset == null) continue;
                long newOffset = offset;
                if (offset < 0L) {
                    if (!metadata.relativeToCurrent) {
                        this.consumer.seekToEnd(Arrays.asList(topicPartition));
                    }
                    newOffset = Math.max(0L, this.consumer.position(topicPartition) + offset);
                } else if (metadata.relativeToCurrent) {
                    newOffset = this.consumer.position(topicPartition) + offset;
                }
                try {
                    this.consumer.seek(topicPartition, newOffset);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Reset " + topicPartition + " to offset " + newOffset));
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to set initial offset for " + topicPartition + " at " + newOffset + ". Position is " + this.consumer.position(topicPartition)), (Throwable)e);
                }
            }
        }

        private void updatePendingOffsets() {
            ConsumerRecord record = (ConsumerRecord)this.acks.poll();
            while (record != null) {
                this.addOffset(record);
                record = (ConsumerRecord)this.acks.poll();
            }
        }

        private void addOffset(ConsumerRecord<K, V> record) {
            Map<Integer, Long> highestOffsetMap;
            Long offset;
            if (!this.offsets.containsKey(record.topic())) {
                this.offsets.put(record.topic(), new HashMap());
            }
            if ((offset = (highestOffsetMap = this.offsets.get(record.topic())).get(record.partition())) == null || record.offset() > offset) {
                highestOffsetMap.put(record.partition(), record.offset());
            }
        }

        private void commitIfNecessary() {
            block9: {
                HashMap<TopicPartition, OffsetAndMetadata> commits = new HashMap<TopicPartition, OffsetAndMetadata>();
                for (Map.Entry<String, Map<Integer, Long>> entry : this.offsets.entrySet()) {
                    for (Map.Entry<Integer, Long> offset : entry.getValue().entrySet()) {
                        commits.put(new TopicPartition(entry.getKey(), offset.getKey().intValue()), new OffsetAndMetadata(offset.getValue() + 1L));
                    }
                }
                this.offsets.clear();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Commit list: " + commits));
                }
                if (!commits.isEmpty()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Committing: " + commits));
                    }
                    try {
                        if (this.containerProperties.isSyncCommits()) {
                            this.consumer.commitSync(commits);
                        } else {
                            this.consumer.commitAsync(commits, this.commitCallback);
                        }
                    }
                    catch (WakeupException e) {
                        if (!this.logger.isDebugEnabled()) break block9;
                        this.logger.debug((Object)"Woken up during commit");
                    }
                }
            }
        }

        private Collection<ConsumerRecord<K, V>> getHighestOffsetRecords(List<ConsumerRecord<K, V>> records) {
            HashMap highestOffsetMap = new HashMap();
            for (ConsumerRecord record : records) {
                TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
                ConsumerRecord consumerRecord = (ConsumerRecord)highestOffsetMap.get(topicPartition);
                if (consumerRecord != null && record.offset() <= consumerRecord.offset()) continue;
                highestOffsetMap.put(topicPartition, record);
            }
            return highestOffsetMap.values();
        }

        @Override
        public void seek(String topic, int partition, long offset) {
            this.seeks.add(new TopicPartitionInitialOffset(topic, partition, offset));
        }

        private final class ConsumerBatchAcknowledgment
        implements Acknowledgment {
            private final List<ConsumerRecord<K, V>> records;
            private final boolean immediate;

            ConsumerBatchAcknowledgment(List<ConsumerRecord<K, V>> records, boolean immediate) {
                this.records = new LinkedList(records);
                this.immediate = immediate;
            }

            @Override
            public void acknowledge() {
                try {
                    Assert.state((boolean)ListenerConsumer.this.isAnyManualAck, (String)"A manual ackmode is required for an acknowledging listener");
                    for (ConsumerRecord record : ListenerConsumer.this.getHighestOffsetRecords(this.records)) {
                        ListenerConsumer.this.acks.put(record);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new KafkaException("Interrupted while queuing ack for " + this.records, e);
                }
                if (this.immediate) {
                    ListenerConsumer.this.consumer.wakeup();
                }
            }

            public String toString() {
                return "Acknowledgment for " + this.records;
            }
        }

        private final class ConsumerAcknowledgment
        implements Acknowledgment {
            private final ConsumerRecord<K, V> record;
            private final boolean immediate;

            ConsumerAcknowledgment(ConsumerRecord<K, V> record, boolean immediate) {
                this.record = record;
                this.immediate = immediate;
            }

            @Override
            public void acknowledge() {
                try {
                    Assert.state((boolean)ListenerConsumer.this.isAnyManualAck, (String)"A manual ackmode is required for an acknowledging listener");
                    ListenerConsumer.this.acks.put(this.record);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new KafkaException("Interrupted while queuing ack for " + this.record, e);
                }
                if (this.immediate) {
                    ListenerConsumer.this.consumer.wakeup();
                }
            }

            public String toString() {
                return "Acknowledgment for " + this.record;
            }
        }

        private final class ListenerInvoker
        implements SchedulingAwareRunnable {
            private final CountDownLatch exitLatch = new CountDownLatch(1);
            private volatile boolean active = true;
            private volatile Thread executingThread;

            ListenerInvoker() {
            }

            public void run() {
                Assert.isTrue((boolean)this.active, (String)"This instance is not active anymore");
                if (ListenerConsumer.this.theListener instanceof ConsumerSeekAware) {
                    ((ConsumerSeekAware)ListenerConsumer.this.theListener).registerSeekCallback(ListenerConsumer.this);
                }
                try {
                    this.executingThread = Thread.currentThread();
                    while (this.active) {
                        try {
                            ConsumerRecords records = (ConsumerRecords)ListenerConsumer.this.recordsToProcess.poll(1L, TimeUnit.SECONDS);
                            if (!this.active) continue;
                            if (records != null) {
                                ListenerConsumer.this.invokeListener(records);
                                continue;
                            }
                            if (!ListenerConsumer.this.logger.isTraceEnabled()) continue;
                            ListenerConsumer.this.logger.trace((Object)"No records to process");
                        }
                        catch (InterruptedException e) {
                            if (!this.active) {
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            ListenerConsumer.this.logger.debug((Object)"Interrupt ignored");
                        }
                    }
                }
                finally {
                    this.active = false;
                    this.exitLatch.countDown();
                }
            }

            public boolean isLongLived() {
                return true;
            }

            private void stop() {
                if (ListenerConsumer.this.logger.isDebugEnabled()) {
                    ListenerConsumer.this.logger.debug((Object)"Stopping invoker");
                }
                this.active = false;
                try {
                    if (!this.exitLatch.await(KafkaMessageListenerContainer.this.getContainerProperties().getShutdownTimeout(), TimeUnit.MILLISECONDS) && this.executingThread != null) {
                        if (ListenerConsumer.this.logger.isDebugEnabled()) {
                            ListenerConsumer.this.logger.debug((Object)"Interrupting invoker");
                        }
                        this.executingThread.interrupt();
                    }
                }
                catch (InterruptedException e) {
                    if (this.executingThread != null) {
                        this.executingThread.interrupt();
                    }
                    Thread.currentThread().interrupt();
                }
                if (ListenerConsumer.this.logger.isDebugEnabled()) {
                    ListenerConsumer.this.logger.debug((Object)"Invoker stopped");
                }
            }
        }
    }
}

