/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.context;

import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.kafka.test.EmbeddedKafkaBrokerFactory;
import org.springframework.kafka.test.context.EmbeddedKafka;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;

class EmbeddedKafkaContextCustomizer
implements ContextCustomizer {
    private final EmbeddedKafka embeddedKafka;

    EmbeddedKafkaContextCustomizer(EmbeddedKafka embeddedKafka) {
        this.embeddedKafka = embeddedKafka;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableEnvironment environment = context.getEnvironment();
        EmbeddedKafkaBroker embeddedKafkaBroker = EmbeddedKafkaBrokerFactory.create(this.embeddedKafka, arg_0 -> ((ConfigurableEnvironment)environment).resolvePlaceholders(arg_0));
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)context;
        genericApplicationContext.registerBean("embeddedKafka", EmbeddedKafkaBroker.class, () -> embeddedKafkaBroker, new BeanDefinitionCustomizer[0]);
    }

    public int hashCode() {
        return this.embeddedKafka.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EmbeddedKafkaContextCustomizer customizer = (EmbeddedKafkaContextCustomizer)obj;
        return this.embeddedKafka.equals(customizer.embeddedKafka);
    }
}

