/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.source;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.xml.source.SourceFactory;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerFactoryUtils;
import org.w3c.dom.Document;

public class StringSourceFactory
implements SourceFactory {
    private final Lock lock = new ReentrantLock();
    private final TransformerFactory transformerFactory;

    public StringSourceFactory() {
        this(TransformerFactoryUtils.newInstance());
    }

    public StringSourceFactory(TransformerFactory transformerFactory) {
        Assert.notNull((Object)transformerFactory, (String)"'transformerFactory' must not be null.");
        this.transformerFactory = transformerFactory;
    }

    @Override
    public Source createSource(Object payload) {
        StringSource source = null;
        if (payload instanceof String) {
            source = new StringSource((String)payload);
        } else if (payload instanceof Document) {
            source = this.createStringSourceForDocument((Document)payload);
        } else if (payload instanceof File) {
            source = this.createStringSourceForFile((File)payload);
        }
        if (source == null) {
            throw new MessagingException("Failed to create Source for payload type [" + payload.getClass().getName() + "]");
        }
        return source;
    }

    private StringSource createStringSourceForDocument(Document document) {
        try {
            StringResult result = new StringResult();
            Transformer transformer = this.getTransformer();
            transformer.transform(new DOMSource(document), (Result)result);
            return new StringSource(result.toString());
        }
        catch (Exception e) {
            throw new MessagingException("failed to create StringSource from document", (Throwable)e);
        }
    }

    private StringSource createStringSourceForFile(File file) {
        try {
            String content = FileCopyUtils.copyToString((Reader)new FileReader(file));
            return new StringSource(content);
        }
        catch (Exception e) {
            throw new MessagingException("failed to create StringSource from file", (Throwable)e);
        }
    }

    private Transformer getTransformer() {
        this.lock.lock();
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            return transformer;
        }
        catch (Exception e) {
            throw new MessagingException("Exception creating transformer", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

