/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractTransformerParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class XPathTransformerParser
extends AbstractTransformerParser {
    protected String getTransformerClassName() {
        return "org.springframework.integration.xml.transformer.XPathTransformer";
    }

    protected void parseTransformer(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String expression = element.getAttribute("xpath-expression");
        String expressionRef = element.getAttribute("xpath-expression-ref");
        boolean hasRef = StringUtils.hasText((String)expressionRef);
        Assert.isTrue((boolean)(hasRef ^ StringUtils.hasText((String)expression)), (String)"Exactly one of the 'xpath-expression' or 'xpath-expression-ref' attributes is required.");
        if (hasRef) {
            builder.addConstructorArgReference(expressionRef);
        } else {
            builder.addConstructorArgValue((Object)expression);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"evaluation-type");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"node-mapper");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"converter");
    }
}

