/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.result;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.springframework.integration.xml.result.ResultFactory;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.xml.DocumentBuilderFactoryUtils;

public class DomResultFactory
implements ResultFactory {
    private final DocumentBuilderFactory documentBuilderFactory;

    public DomResultFactory() {
        this(DocumentBuilderFactoryUtils.newInstance());
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public DomResultFactory(DocumentBuilderFactory documentBuilderFactory) {
        Assert.notNull((Object)documentBuilderFactory, (String)"'documentBuilderFactory' must not be null.");
        this.documentBuilderFactory = documentBuilderFactory;
    }

    @Override
    public synchronized Result createResult(Object payload) {
        try {
            return new DOMResult(this.getNewDocumentBuilder().newDocument());
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException("failed to create Result for payload type [" + payload.getClass().getName() + "]", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = this.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            return this.documentBuilderFactory.newDocumentBuilder();
        }
    }
}

