/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.xml.transformer.ResultTransformer;
import org.springframework.messaging.MessagingException;
import org.springframework.xml.transform.StringResult;

public class ResultToStringTransformer
implements ResultTransformer {
    private volatile Properties outputProperties;
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }

    @Override
    public Object transformResult(Result result) {
        String returnString = null;
        if (result instanceof StringResult) {
            returnString = ((StringResult)result).toString();
        } else if (result instanceof DOMResult) {
            try {
                StringResult stringResult = new StringResult();
                this.getNewTransformer().transform(new DOMSource(((DOMResult)result).getNode()), (Result)stringResult);
                returnString = stringResult.toString();
            }
            catch (TransformerException e) {
                throw new MessagingException("failed to transform from DOMSource failed", (Throwable)e);
            }
        }
        if (returnString == null) {
            throw new MessagingException("failed to convert Result type [" + result.getClass().getName() + "] to string");
        }
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer getNewTransformer() throws TransformerConfigurationException {
        Transformer transformer = null;
        TransformerFactory transformerFactory = this.transformerFactory;
        synchronized (transformerFactory) {
            transformer = this.transformerFactory.newTransformer();
        }
        if (this.outputProperties != null) {
            transformer.setOutputProperties(this.outputProperties);
        }
        return transformer;
    }
}

