/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.AbstractPollingEndpoint;
import org.springframework.integration.endpoint.IntegrationConsumer;
import org.springframework.integration.endpoint.ReactiveStreamsConsumer;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.integration.test.mock.MockMessageHandler;
import org.springframework.integration.test.util.TestUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.ReactiveMessageHandler;
import org.springframework.scheduling.Trigger;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;

public class MockIntegrationContext
implements BeanPostProcessor,
SmartInitializingSingleton,
BeanFactoryAware {
    private static final String HANDLER = "handler";
    private static final String REACTIVE_MESSAGE_HANDLER = "reactiveMessageHandler";
    public static final String MOCK_INTEGRATION_CONTEXT_BEAN_NAME = "mockIntegrationContext";
    private final MultiValueMap<String, Object> beans = new LinkedMultiValueMap();
    private final List<AbstractEndpoint> autoStartupCandidates = new ArrayList<AbstractEndpoint>();
    private ConfigurableListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isAssignable(ConfigurableListableBeanFactory.class, beanFactory.getClass(), (String)"a ConfigurableListableBeanFactory is required");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        AbstractEndpoint endpoint;
        if (bean instanceof AbstractEndpoint && (endpoint = (AbstractEndpoint)bean).isAutoStartup()) {
            this.addAutoStartupCandidates(endpoint);
        }
        return bean;
    }

    private void addAutoStartupCandidates(AbstractEndpoint endpoint) {
        endpoint.setAutoStartup(false);
        this.autoStartupCandidates.add(endpoint);
    }

    public void afterSingletonsInstantiated() {
        this.beanFactory.getBeansOfType(AbstractEndpoint.class).values().stream().filter(AbstractEndpoint::isAutoStartup).forEach(this::addAutoStartupCandidates);
    }

    List<AbstractEndpoint> getAutoStartupCandidates() {
        return this.autoStartupCandidates;
    }

    public void resetBeans(String ... beanNames) {
        List<String> names = !ObjectUtils.isEmpty((Object[])beanNames) ? Arrays.asList(beanNames) : null;
        this.beans.entrySet().stream().filter(bean -> names == null || names.contains(bean.getKey())).forEach(bean -> {
            Object endpoint = this.beanFactory.getBean((String)bean.getKey());
            ((List)bean.getValue()).forEach(value -> this.resetBean(endpoint, value));
        });
        if (!ObjectUtils.isEmpty((Object[])beanNames)) {
            for (String name : beanNames) {
                this.beans.remove((Object)name);
            }
        } else {
            this.beans.clear();
        }
    }

    private void resetBean(Object endpoint, Object component) {
        SmartLifecycle lifecycleEndpoint;
        DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(endpoint);
        SmartLifecycle lifecycle = null;
        if (endpoint instanceof SmartLifecycle && (lifecycleEndpoint = (SmartLifecycle)endpoint).isRunning()) {
            lifecycle = lifecycleEndpoint;
            lifecycle.stop();
        }
        if (endpoint instanceof SourcePollingChannelAdapter && component instanceof MessageSource) {
            directFieldAccessor.setPropertyValue("source", component);
        } else if (endpoint instanceof IntegrationConsumer && component instanceof MessageHandler) {
            directFieldAccessor.setPropertyValue(HANDLER, component);
        } else if (endpoint instanceof ReactiveStreamsConsumer && component instanceof ReactiveMessageHandler) {
            directFieldAccessor.setPropertyValue(REACTIVE_MESSAGE_HANDLER, component);
        } else if (component instanceof Trigger) {
            directFieldAccessor.setPropertyValue("trigger", component);
        }
        if (lifecycle != null && lifecycle.isAutoStartup()) {
            lifecycle.start();
        }
    }

    public void substituteMessageSourceFor(String pollingAdapterId, MessageSource<?> mockMessageSource) {
        this.substituteMessageSourceFor(pollingAdapterId, mockMessageSource, true);
    }

    public void substituteMessageSourceFor(String pollingAdapterId, MessageSource<?> mockMessageSource, boolean autoStartup) {
        this.substituteComponentFor(pollingAdapterId, mockMessageSource, SourcePollingChannelAdapter.class, "source", autoStartup);
    }

    public void substituteMessageHandlerFor(String consumerEndpointId, MessageHandler mockMessageHandler) {
        this.substituteMessageHandlerFor(consumerEndpointId, mockMessageHandler, true);
    }

    public void substituteMessageHandlerFor(String consumerEndpointId, MessageHandler mockMessageHandler, boolean autoStartup) {
        Object targetReactiveMessageHandler;
        Object endpoint = this.beanFactory.getBean(consumerEndpointId, IntegrationConsumer.class);
        if (autoStartup && endpoint instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)endpoint;
            lifecycle.stop();
        }
        DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(endpoint);
        Object targetMessageHandler = directFieldAccessor.getPropertyValue(HANDLER);
        Assert.notNull((Object)targetMessageHandler, () -> "'handler' must not be null in the: " + endpoint);
        this.beans.add((Object)consumerEndpointId, targetMessageHandler);
        if (endpoint instanceof ReactiveStreamsConsumer && (targetReactiveMessageHandler = directFieldAccessor.getPropertyValue(REACTIVE_MESSAGE_HANDLER)) != null) {
            this.beans.add((Object)consumerEndpointId, targetReactiveMessageHandler);
        }
        if (mockMessageHandler instanceof MessageProducer) {
            MessageProducer mockMessageProducer = (MessageProducer)mockMessageHandler;
            if (targetMessageHandler instanceof MessageProducer) {
                MessageProducer messageProducer = (MessageProducer)targetMessageHandler;
                MessageChannel outputChannel = messageProducer.getOutputChannel();
                mockMessageProducer.setOutputChannel(outputChannel);
            } else if (mockMessageHandler instanceof MockMessageHandler) {
                if (((Boolean)TestUtils.getPropertyValue((Object)mockMessageHandler, (String)"hasReplies", Boolean.class)).booleanValue()) {
                    throw new IllegalStateException("The [" + mockMessageHandler + "] with replies can't replace simple MessageHandler [" + targetMessageHandler + "]");
                }
            } else {
                throw new IllegalStateException("The MessageProducer handler [" + mockMessageHandler + "] can't replace simple MessageHandler [" + targetMessageHandler + "]");
            }
        }
        directFieldAccessor.setPropertyValue(HANDLER, (Object)mockMessageHandler);
        if (endpoint instanceof ReactiveStreamsConsumer) {
            ReactiveMessageHandler reactiveMessageHandler = message -> Mono.fromRunnable(() -> mockMessageHandler.handleMessage(message));
            directFieldAccessor.setPropertyValue(REACTIVE_MESSAGE_HANDLER, (Object)reactiveMessageHandler);
        }
        if (autoStartup && endpoint instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)endpoint;
            lifecycle.start();
        }
    }

    public void substituteTriggerFor(String pollingEndpointId, Trigger trigger) {
        this.substituteTriggerFor(pollingEndpointId, trigger, true);
    }

    public void substituteTriggerFor(String pollingEndpointId, Trigger trigger, boolean autoStartup) {
        this.substituteComponentFor(pollingEndpointId, trigger, AbstractPollingEndpoint.class, "trigger", autoStartup);
    }

    private void substituteComponentFor(String endpointId, Object messagingComponent, Class<?> endpointClass, String property, boolean autoStartup) {
        Object endpoint = this.beanFactory.getBean(endpointId, endpointClass);
        if (autoStartup && endpoint instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)endpoint;
            lifecycle.stop();
        }
        DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(endpoint);
        this.beans.add((Object)endpointId, directFieldAccessor.getPropertyValue(property));
        directFieldAccessor.setPropertyValue(property, messagingComponent);
        if (autoStartup && endpoint instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)endpoint;
            lifecycle.start();
        }
    }
}

