/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.server;

import java.nio.file.Path;
import org.springframework.integration.sftp.server.ApacheMinaSftpEvent;
import org.springframework.lang.Nullable;

public class FileWrittenEvent
extends ApacheMinaSftpEvent {
    private static final long serialVersionUID = 1L;
    private final String remoteHandle;
    private transient Path file;
    private final int dataLen;

    public FileWrittenEvent(Object source, String remoteHandle, Path file, int dataLen, @Nullable Throwable thrown) {
        super(source, thrown);
        this.remoteHandle = remoteHandle;
        this.file = file;
        this.dataLen = dataLen;
    }

    public String getRemoteHandle() {
        return this.remoteHandle;
    }

    @Nullable
    public Path getFile() {
        return this.file;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public String toString() {
        return "FileWrittenEvent [remoteHandle=" + this.remoteHandle + ", file=" + String.valueOf(this.file) + ", dataLen=" + this.dataLen + (String)(this.cause == null ? "" : ", cause=" + String.valueOf(this.cause)) + ", clientAddress=" + String.valueOf(this.getSession().getClientAddress()) + "]";
    }
}

