/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rsocket;

import io.rsocket.Payload;
import io.rsocket.frame.FrameType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.codec.Encoder;
import org.springframework.integration.rsocket.IntegrationRSocketEndpoint;
import org.springframework.integration.rsocket.RSocketInteractionModel;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.ReactiveMessageHandler;
import org.springframework.messaging.handler.CompositeMessageCondition;
import org.springframework.messaging.handler.DestinationPatternsMessageCondition;
import org.springframework.messaging.handler.MessageCondition;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodReturnValueHandler;
import org.springframework.messaging.handler.invocation.reactive.SyncHandlerMethodArgumentResolver;
import org.springframework.messaging.rsocket.annotation.support.RSocketFrameTypeMessageCondition;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.messaging.rsocket.annotation.support.RSocketPayloadReturnValueHandler;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class IntegrationRSocketMessageHandler
extends RSocketMessageHandler {
    private static final Method HANDLE_MESSAGE_METHOD = ReflectionUtils.findMethod(ReactiveMessageHandler.class, (String)"handleMessage", (Class[])new Class[]{Message.class});
    protected final boolean messageMappingCompatible;

    IntegrationRSocketMessageHandler() {
        this(false);
    }

    IntegrationRSocketMessageHandler(boolean messageMappingCompatible) {
        this.messageMappingCompatible = messageMappingCompatible;
        if (!this.messageMappingCompatible) {
            this.setHandlerPredicate(clazz -> false);
        }
    }

    public boolean detectEndpoints() {
        ApplicationContext applicationContext = this.getApplicationContext();
        boolean endpointsDetected = false;
        if (applicationContext != null && this.getHandlerMethods().isEmpty()) {
            Collection endpoints = applicationContext.getBeansOfType(IntegrationRSocketEndpoint.class).values();
            for (IntegrationRSocketEndpoint endpoint : endpoints) {
                this.addEndpoint(endpoint);
                endpointsDetected = true;
            }
        }
        return endpointsDetected;
    }

    public void addEndpoint(IntegrationRSocketEndpoint endpoint) {
        RSocketFrameTypeMessageCondition frameTypeMessageCondition = RSocketFrameTypeMessageCondition.EMPTY_CONDITION;
        RSocketInteractionModel[] interactionModels = endpoint.getInteractionModels();
        if (interactionModels.length > 0) {
            frameTypeMessageCondition = new RSocketFrameTypeMessageCondition((FrameType[])Arrays.stream(interactionModels).map(RSocketInteractionModel::getFrameType).toArray(FrameType[]::new));
        }
        this.registerHandlerMethod(endpoint, HANDLE_MESSAGE_METHOD, new CompositeMessageCondition(new MessageCondition[]{frameTypeMessageCondition, new DestinationPatternsMessageCondition(endpoint.getPath(), this.getRouteMatcher())}));
    }

    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        if (this.messageMappingCompatible) {
            this.getArgumentResolverConfigurer().addCustomResolver(new HandlerMethodArgumentResolver[]{new MessageHandlerMethodArgumentResolver()});
            return super.initArgumentResolvers();
        }
        return Collections.singletonList(new MessageHandlerMethodArgumentResolver());
    }

    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        IntegrationRSocketPayloadReturnValueHandler integrationRSocketPayloadReturnValueHandler = new IntegrationRSocketPayloadReturnValueHandler(this.getEncoders(), this.getReactiveAdapterRegistry());
        if (this.messageMappingCompatible) {
            ArrayList<IntegrationRSocketPayloadReturnValueHandler> handlers = new ArrayList<IntegrationRSocketPayloadReturnValueHandler>();
            handlers.add(integrationRSocketPayloadReturnValueHandler);
            handlers.addAll(this.getReturnValueHandlerConfigurer().getCustomHandlers());
            return handlers;
        }
        return Collections.singletonList(integrationRSocketPayloadReturnValueHandler);
    }

    protected static final class MessageHandlerMethodArgumentResolver
    implements SyncHandlerMethodArgumentResolver {
        protected MessageHandlerMethodArgumentResolver() {
        }

        public boolean supportsParameter(MethodParameter parameter) {
            return Message.class.equals((Object)parameter.getParameterType());
        }

        public Object resolveArgumentValue(MethodParameter parameter, Message<?> message) {
            return message;
        }
    }

    protected static final class IntegrationRSocketPayloadReturnValueHandler
    extends RSocketPayloadReturnValueHandler {
        protected IntegrationRSocketPayloadReturnValueHandler(List<Encoder<?>> encoders, ReactiveAdapterRegistry registry) {
            super(encoders, registry);
        }

        public Mono<Void> handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, Message<?> message) {
            AtomicReference<Flux<Payload>> responseReference = IntegrationRSocketPayloadReturnValueHandler.getResponseReference(message);
            if (returnValue == null && responseReference != null) {
                return super.handleReturnValue(responseReference.get(), returnType, message);
            }
            return super.handleReturnValue(returnValue, returnType, message);
        }

        @Nullable
        private static AtomicReference<Flux<Payload>> getResponseReference(Message<?> message) {
            Object headerValue = message.getHeaders().get((Object)"rsocketResponse");
            Assert.state((headerValue == null || headerValue instanceof AtomicReference ? 1 : 0) != 0, (String)"Expected AtomicReference");
            return (AtomicReference)headerValue;
        }
    }
}

