/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rsocket;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.rsocket.IntegrationRSocketEndpoint;
import org.springframework.integration.rsocket.IntegrationRSocketMessageHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public abstract class AbstractRSocketConnector
implements ApplicationContextAware,
InitializingBean,
DisposableBean,
SmartInitializingSingleton,
SmartLifecycle {
    protected final IntegrationRSocketMessageHandler rSocketMessageHandler;
    private boolean autoStartup = true;
    private volatile boolean running;

    protected AbstractRSocketConnector(IntegrationRSocketMessageHandler rSocketMessageHandler) {
        Assert.notNull((Object)((Object)rSocketMessageHandler), (String)"'rSocketMessageHandler' must not be null");
        this.rSocketMessageHandler = rSocketMessageHandler;
    }

    public void setDataMimeType(@Nullable MimeType dataMimeType) {
        this.rSocketMessageHandler.setDefaultDataMimeType(dataMimeType);
    }

    @Nullable
    protected MimeType getDataMimeType() {
        return this.rSocketMessageHandler.getDefaultDataMimeType();
    }

    public void setMetadataMimeType(MimeType metadataMimeType) {
        this.rSocketMessageHandler.setDefaultMetadataMimeType(metadataMimeType);
    }

    protected MimeType getMetadataMimeType() {
        return this.rSocketMessageHandler.getDefaultMetadataMimeType();
    }

    public void setRSocketStrategies(RSocketStrategies rsocketStrategies) {
        this.rSocketMessageHandler.setRSocketStrategies(rsocketStrategies);
    }

    public RSocketStrategies getRSocketStrategies() {
        return this.rSocketMessageHandler.getRSocketStrategies();
    }

    public void setEndpoints(IntegrationRSocketEndpoint ... endpoints) {
        Assert.notNull((Object)endpoints, (String)"'endpoints' must not be null");
        for (IntegrationRSocketEndpoint endpoint : endpoints) {
            this.addEndpoint(endpoint);
        }
    }

    public void addEndpoint(IntegrationRSocketEndpoint endpoint) {
        this.rSocketMessageHandler.addEndpoint(endpoint);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.rSocketMessageHandler.setApplicationContext(applicationContext);
    }

    public void afterPropertiesSet() {
        this.rSocketMessageHandler.afterPropertiesSet();
    }

    public void afterSingletonsInstantiated() {
        this.rSocketMessageHandler.detectEndpoints();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.doStart();
        }
    }

    protected abstract void doStart();

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }
}

