/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.redis.outbound.RedisPublishingMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RedisOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RedisPublishingMessageHandler.class);
        String connectionFactory = element.getAttribute("connection-factory");
        if (!StringUtils.hasText((String)connectionFactory)) {
            connectionFactory = "redisConnectionFactory";
        }
        builder.addConstructorArgReference(connectionFactory);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"serializer");
        BeanDefinition topicExpression = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"topic", (String)"topic-expression", (ParserContext)parserContext, (Element)element, (boolean)true);
        builder.addPropertyValue("topicExpression", (Object)topicExpression);
        return builder.getBeanDefinition();
    }
}

