/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.inbound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SimpleMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisInboundChannelAdapter
extends MessageProducerSupport {
    private final RedisMessageListenerContainer container = new RedisMessageListenerContainer();
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile String[] topics;
    private volatile String[] topicPatterns;
    private volatile RedisSerializer<?> serializer = new StringRedisSerializer();

    public RedisInboundChannelAdapter(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        this.container.setConnectionFactory(connectionFactory);
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        this.serializer = serializer;
    }

    public void setTopics(String ... topics) {
        Assert.notEmpty((Object[])topics, (String)"at least one topic is required");
        this.topics = Arrays.copyOf(topics, topics.length);
    }

    public void setTopicPatterns(String ... topicPatterns) {
        Assert.notEmpty((Object[])topicPatterns, (String)"at least one topic pattern is required");
        this.topicPatterns = Arrays.copyOf(topicPatterns, topicPatterns.length);
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter must not be null");
        this.messageConverter = messageConverter;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.container.setTaskExecutor(taskExecutor);
    }

    public String getComponentType() {
        return "redis:inbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        boolean hasTopics = false;
        if (this.topics != null) {
            Assert.noNullElements((Object[])this.topics, (String)"'topics' may not contain null elements.");
            hasTopics = true;
        }
        boolean hasPatterns = false;
        if (this.topicPatterns != null) {
            Assert.noNullElements((Object[])this.topicPatterns, (String)"'topicPatterns' may not contain null elements.");
            hasPatterns = true;
        }
        Assert.state((hasTopics || hasPatterns ? 1 : 0) != 0, (String)"at least one topic or topic pattern is required for subscription.");
        if (this.messageConverter instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.messageConverter).setBeanFactory(this.getBeanFactory());
        }
        MessageListenerDelegate delegate = new MessageListenerDelegate();
        MessageListenerAdapter adapter = new MessageListenerAdapter((Object)delegate);
        adapter.setSerializer(this.serializer);
        ArrayList<Object> topicList = new ArrayList<Object>();
        if (hasTopics) {
            for (String topic : this.topics) {
                topicList.add(new ChannelTopic(topic));
            }
        }
        if (hasPatterns) {
            for (String pattern : this.topicPatterns) {
                topicList.add(new PatternTopic(pattern));
            }
        }
        adapter.afterPropertiesSet();
        this.container.addMessageListener((MessageListener)adapter, topicList);
        this.container.afterPropertiesSet();
    }

    protected void doStart() {
        this.container.start();
    }

    protected void doStop() {
        this.container.stop();
    }

    private Message<?> convertMessage(Object object, String source) {
        MessageHeaders messageHeaders = null;
        if (StringUtils.hasText((String)source)) {
            messageHeaders = new MessageHeaders(Collections.singletonMap("redis_messageSource", source));
        }
        return this.messageConverter.toMessage(object, messageHeaders);
    }

    private class MessageListenerDelegate {
        MessageListenerDelegate() {
        }

        public void handleMessage(Object message, String source) {
            RedisInboundChannelAdapter.this.sendMessage(RedisInboundChannelAdapter.this.convertMessage(message, source));
        }
    }
}

