/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.inbound;

import org.apache.kafka.clients.consumer.Consumer;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;

public interface KafkaInboundEndpoint {
    public static final String CONTEXT_ACKNOWLEDGMENT = "acknowledgment";
    public static final String CONTEXT_CONSUMER = "consumer";
    public static final String CONTEXT_RECORD = "record";

    default public void doWithRetry(RetryTemplate template, RecoveryCallback<?> callback, Object data, Acknowledgment acknowledgment, Consumer<?, ?> consumer, Runnable runnable) {
        try {
            template.execute(context -> {
                context.setAttribute(CONTEXT_RECORD, data);
                context.setAttribute(CONTEXT_ACKNOWLEDGMENT, (Object)acknowledgment);
                context.setAttribute(CONTEXT_CONSUMER, (Object)consumer);
                runnable.run();
                return null;
            }, callback);
        }
        catch (Exception ex) {
            throw new KafkaException("Failed to execute runnable", (Throwable)ex);
        }
    }
}

