/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.jms.JmsHeaderMapper;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.StringUtils;

public class DefaultJmsHeaderMapper
extends JmsHeaderMapper {
    private static final List<Class<?>> SUPPORTED_PROPERTY_TYPES = Arrays.asList(Boolean.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class);
    private static final Log LOGGER = LogFactory.getLog(DefaultJmsHeaderMapper.class);
    private volatile String inboundPrefix = "";
    private volatile String outboundPrefix = "";
    private volatile boolean mapInboundPriority = true;
    private volatile boolean mapInboundDeliveryMode = false;
    private volatile boolean mapInboundExpiration = false;

    public void setMapInboundPriority(boolean mapInboundPriority) {
        this.mapInboundPriority = mapInboundPriority;
    }

    public void setMapInboundDeliveryMode(boolean mapInboundDeliveryMode) {
        this.mapInboundDeliveryMode = mapInboundDeliveryMode;
    }

    public void setMapInboundExpiration(boolean mapInboundExpiration) {
        this.mapInboundExpiration = mapInboundExpiration;
    }

    public void setInboundPrefix(String inboundPrefix) {
        this.inboundPrefix = inboundPrefix != null ? inboundPrefix : "";
    }

    public void setOutboundPrefix(String outboundPrefix) {
        this.outboundPrefix = outboundPrefix != null ? outboundPrefix : "";
    }

    public void fromHeaders(MessageHeaders headers, Message jmsMessage) {
        try {
            this.populateCorrelationIdPropertyFromHeaders(headers, jmsMessage);
            this.populateReplyToPropertyFromHeaders(headers, jmsMessage);
            this.populateTypePropertyFromHeaders(headers, jmsMessage);
            for (Map.Entry entry : headers.entrySet()) {
                Object value;
                String headerName = (String)entry.getKey();
                if (!StringUtils.hasText((String)headerName) || headerName.startsWith("jms_") || jmsMessage.getObjectProperty(headerName) != null || (value = entry.getValue()) == null) continue;
                this.populateArbitraryHeaderToProperty(jmsMessage, headerName, value);
            }
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"Error occurred while mapping from MessageHeaders to JMS properties", (Throwable)ex);
        }
    }

    private void populateCorrelationIdPropertyFromHeaders(MessageHeaders headers, Message jmsMessage) {
        Object jmsCorrelationId = headers.get((Object)"jms_correlationId");
        if (jmsCorrelationId instanceof Number) {
            jmsCorrelationId = jmsCorrelationId.toString();
        }
        if (jmsCorrelationId instanceof String) {
            try {
                jmsMessage.setJMSCorrelationID((String)jmsCorrelationId);
            }
            catch (Exception ex) {
                LOGGER.info((Object)"Failed to set JMSCorrelationID, skipping", (Throwable)ex);
            }
        }
    }

    private void populateReplyToPropertyFromHeaders(MessageHeaders headers, Message jmsMessage) {
        Object jmsReplyTo = headers.get((Object)"jms_replyTo");
        if (jmsReplyTo instanceof Destination) {
            try {
                jmsMessage.setJMSReplyTo((Destination)jmsReplyTo);
            }
            catch (Exception ex) {
                LOGGER.info((Object)"Failed to set JMSReplyTo, skipping", (Throwable)ex);
            }
        }
    }

    private void populateTypePropertyFromHeaders(MessageHeaders headers, Message jmsMessage) {
        Object jmsType = headers.get((Object)"jms_type");
        if (jmsType instanceof String) {
            try {
                jmsMessage.setJMSType((String)jmsType);
            }
            catch (Exception ex) {
                LOGGER.info((Object)"Failed to set JMSType, skipping", (Throwable)ex);
            }
        }
    }

    private void populateArbitraryHeaderToProperty(Message jmsMessage, String headerName, Object value) throws JMSException {
        if (SUPPORTED_PROPERTY_TYPES.contains(value.getClass())) {
            try {
                String propertyName = this.fromHeaderName(headerName);
                jmsMessage.setObjectProperty(propertyName, value);
            }
            catch (Exception e) {
                if (headerName.startsWith("JMSX") || headerName.equals("priority")) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("skipping reserved header, it cannot be set by client: " + headerName));
                    }
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("failed to map Message header '" + headerName + "' to JMS property"), (Throwable)e);
                }
            }
        } else if ("correlationId".equals(headerName)) {
            String propertyName = this.fromHeaderName(headerName);
            jmsMessage.setObjectProperty(propertyName, (Object)value.toString());
        }
    }

    public Map<String, Object> toHeaders(Message jmsMessage) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        try {
            this.mapMessageIdProperty(jmsMessage, headers);
            this.mapDestinationProperty(jmsMessage, headers);
            this.mapCorrelationIdProperty(jmsMessage, headers);
            this.mapReplyToProperty(jmsMessage, headers);
            this.mapRedeliveredProperty(jmsMessage, headers);
            this.mapTypeProperty(jmsMessage, headers);
            this.mapTimestampProperty(jmsMessage, headers);
            this.mapPriorityProperty(jmsMessage, headers);
            this.mapDeliveryModeProperty(jmsMessage, headers);
            this.mapExpirationProperty(jmsMessage, headers);
            Enumeration jmsPropertyNames = jmsMessage.getPropertyNames();
            if (jmsPropertyNames != null) {
                while (jmsPropertyNames.hasMoreElements()) {
                    String propertyName = jmsPropertyNames.nextElement().toString();
                    this.mapArbitraryProperty(jmsMessage, headers, propertyName);
                }
            }
        }
        catch (JMSException ex) {
            LOGGER.warn((Object)"error occurred while mapping from JMS properties to MessageHeaders", (Throwable)ex);
        }
        return headers;
    }

    private void mapMessageIdProperty(Message jmsMessage, Map<String, Object> headers) {
        try {
            String messageId = jmsMessage.getJMSMessageID();
            if (messageId != null) {
                headers.put("jms_messageId", messageId);
            }
        }
        catch (Exception ex) {
            LOGGER.info((Object)"Failed to read JMSMessageID property, skipping", (Throwable)ex);
        }
    }

    private void mapDestinationProperty(Message jmsMessage, Map<String, Object> headers) {
        try {
            Destination destination = jmsMessage.getJMSDestination();
            if (destination != null) {
                headers.put("jms_destination", destination);
            }
        }
        catch (Exception ex) {
            LOGGER.info((Object)"Failed to read JMSDestination property, skipping", (Throwable)ex);
        }
    }

    private void mapCorrelationIdProperty(Message jmsMessage, Map<String, Object> headers) {
        try {
            String correlationId = jmsMessage.getJMSCorrelationID();
            if (correlationId != null) {
                headers.put("jms_correlationId", correlationId);
            }
        }
        catch (Exception ex) {
            LOGGER.info((Object)"Failed to read JMSCorrelationID property, skipping", (Throwable)ex);
        }
    }

    private void mapReplyToProperty(Message jmsMessage, Map<String, Object> headers) {
        try {
            Destination replyTo = jmsMessage.getJMSReplyTo();
            if (replyTo != null) {
                headers.put("jms_replyTo", replyTo);
            }
        }
        catch (Exception ex) {
            LOGGER.info((Object)"failed to read JMSReplyTo property, skipping", (Throwable)ex);
        }
    }

    private void mapRedeliveredProperty(Message jmsMessage, Map<String, Object> headers) {
        try {
            headers.put("jms_redelivered", jmsMessage.getJMSRedelivered());
        }
        catch (Exception ex) {
            LOGGER.info((Object)"failed to read JMSRedelivered property, skipping", (Throwable)ex);
        }
    }

    private void mapTypeProperty(Message jmsMessage, Map<String, Object> headers) {
        try {
            String type = jmsMessage.getJMSType();
            if (type != null) {
                headers.put("jms_type", type);
            }
        }
        catch (Exception ex) {
            LOGGER.info((Object)"Failed to read JMSType property, skipping", (Throwable)ex);
        }
    }

    private void mapTimestampProperty(Message jmsMessage, Map<String, Object> headers) {
        try {
            headers.put("jms_timestamp", jmsMessage.getJMSTimestamp());
        }
        catch (Exception ex) {
            LOGGER.info((Object)"failed to read JMSTimestamp property, skipping", (Throwable)ex);
        }
    }

    private void mapPriorityProperty(Message jmsMessage, Map<String, Object> headers) {
        if (this.mapInboundPriority) {
            try {
                headers.put("priority", jmsMessage.getJMSPriority());
            }
            catch (Exception ex) {
                LOGGER.info((Object)"Failed to read JMSPriority property, skipping", (Throwable)ex);
            }
        }
    }

    private void mapDeliveryModeProperty(Message jmsMessage, Map<String, Object> headers) {
        if (this.mapInboundDeliveryMode) {
            try {
                headers.put("jms_deliveryMode", jmsMessage.getJMSDeliveryMode());
            }
            catch (Exception ex) {
                LOGGER.info((Object)"Failed to read JMSDeliveryMode property, skipping", (Throwable)ex);
            }
        }
    }

    private void mapExpirationProperty(Message jmsMessage, Map<String, Object> headers) {
        if (this.mapInboundExpiration) {
            try {
                headers.put("jms_expiration", jmsMessage.getJMSExpiration());
            }
            catch (Exception ex) {
                LOGGER.info((Object)"Failed to read JMSExpiration property, skipping", (Throwable)ex);
            }
        }
    }

    private void mapArbitraryProperty(Message jmsMessage, Map<String, Object> headers, String propertyName) {
        block2: {
            try {
                String headerName = this.toHeaderName(propertyName);
                headers.put(headerName, jmsMessage.getObjectProperty(propertyName));
            }
            catch (Exception ex) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn((Object)("Error occurred while mapping JMS property '" + propertyName + "' to Message header"), (Throwable)ex);
            }
        }
    }

    private String fromHeaderName(String headerName) {
        String propertyName = headerName;
        if (StringUtils.hasText((String)this.outboundPrefix) && !propertyName.startsWith(this.outboundPrefix)) {
            propertyName = this.outboundPrefix + headerName;
        } else if ("contentType".equals(headerName)) {
            propertyName = "content_type";
        }
        return propertyName;
    }

    private String toHeaderName(String propertyName) {
        String headerName = propertyName;
        if (StringUtils.hasText((String)this.inboundPrefix) && !headerName.startsWith(this.inboundPrefix)) {
            headerName = this.inboundPrefix + propertyName;
        } else if ("content_type".equals(propertyName)) {
            headerName = "contentType";
        }
        return headerName;
    }
}

