/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.jdbc.BeanPropertySqlParameterSourceFactory;
import org.springframework.integration.jdbc.MessagePreparedStatementSetter;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class JdbcMessageHandler
extends AbstractMessageHandler {
    private final ResultSetExtractor<List<Map<String, Object>>> generatedKeysResultSetExtractor = new RowMapperResultSetExtractor((RowMapper)new ColumnMapRowMapper(), 1);
    private final NamedParameterJdbcOperations jdbcOperations;
    private final String updateSql;
    private PreparedStatementCreator generatedKeysStatementCreator;
    private SqlParameterSourceFactory sqlParameterSourceFactory;
    private boolean keysGenerated;
    private MessagePreparedStatementSetter preparedStatementSetter;

    public JdbcMessageHandler(DataSource dataSource, String updateSql) {
        this((JdbcOperations)new JdbcTemplate(dataSource), updateSql);
    }

    public JdbcMessageHandler(JdbcOperations jdbcOperations, String updateSql) {
        Assert.notNull((Object)jdbcOperations, (String)"'jdbcOperations' must not be null.");
        Assert.hasText((String)updateSql, (String)"'updateSql' must not be empty.");
        this.jdbcOperations = new NamedParameterJdbcTemplate(jdbcOperations);
        this.updateSql = updateSql;
    }

    public void setKeysGenerated(boolean keysGenerated) {
        this.keysGenerated = keysGenerated;
    }

    public void setSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
    }

    public void setPreparedStatementSetter(@Nullable MessagePreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
        if (preparedStatementSetter != null) {
            PreparedStatementCreatorFactory preparedStatementCreatorFactory = new PreparedStatementCreatorFactory(this.updateSql);
            preparedStatementCreatorFactory.setReturnGeneratedKeys(true);
            this.generatedKeysStatementCreator = preparedStatementCreatorFactory.newPreparedStatementCreator((Object[])null);
        }
    }

    public String getComponentType() {
        return "jdbc:outbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        Assert.state((this.sqlParameterSourceFactory == null || this.preparedStatementSetter == null ? 1 : 0) != 0, (String)"'sqlParameterSourceFactory' and 'preparedStatementSetter' are mutually exclusive.");
        if (this.sqlParameterSourceFactory == null && this.preparedStatementSetter == null) {
            this.sqlParameterSourceFactory = new BeanPropertySqlParameterSourceFactory();
        }
    }

    protected void handleMessageInternal(Message<?> message) {
        List<? extends Map<String, Object>> keys = this.executeUpdateQuery(message, this.keysGenerated);
        if (!keys.isEmpty()) {
            this.logger.debug(() -> "Generated keys: " + String.valueOf(keys));
        }
    }

    protected List<? extends Map<String, Object>> executeUpdateQuery(Message<?> message, boolean keysGenerated) {
        if (keysGenerated) {
            if (this.preparedStatementSetter != null) {
                return (List)this.jdbcOperations.getJdbcOperations().execute(this.generatedKeysStatementCreator, ps -> {
                    this.preparedStatementSetter.setValues(ps, message);
                    ps.executeUpdate();
                    ResultSet keys = ps.getGeneratedKeys();
                    if (keys != null) {
                        try {
                            List list = (List)this.generatedKeysResultSetExtractor.extractData(keys);
                            return list;
                        }
                        finally {
                            JdbcUtils.closeResultSet((ResultSet)keys);
                        }
                    }
                    return new LinkedList();
                });
            }
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.jdbcOperations.update(this.updateSql, this.sqlParameterSourceFactory.createParameterSource(message), (KeyHolder)keyHolder);
            return keyHolder.getKeyList();
        }
        if (message.getPayload() instanceof Iterable) {
            int[] updates;
            Stream<Message> messageStream = StreamSupport.stream(((Iterable)message.getPayload()).spliterator(), false).map(payload -> JdbcMessageHandler.payloadToMessage(payload, message.getHeaders()));
            if (this.preparedStatementSetter != null) {
                final Message[] messages = (Message[])messageStream.toArray(Message[]::new);
                updates = this.jdbcOperations.getJdbcOperations().batchUpdate(this.updateSql, new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        JdbcMessageHandler.this.preparedStatementSetter.setValues(ps, messages[i]);
                    }

                    public int getBatchSize() {
                        return messages.length;
                    }
                });
            } else {
                SqlParameterSource[] sqlParameterSources = (SqlParameterSource[])messageStream.map(this.sqlParameterSourceFactory::createParameterSource).toArray(SqlParameterSource[]::new);
                updates = this.jdbcOperations.batchUpdate(this.updateSql, sqlParameterSources);
            }
            return Arrays.stream(updates).mapToObj(updated -> {
                LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap();
                map.put("UPDATED", updated);
                return map;
            }).collect(Collectors.toList());
        }
        int updated2 = this.preparedStatementSetter != null ? this.jdbcOperations.getJdbcOperations().update(this.updateSql, ps -> this.preparedStatementSetter.setValues(ps, message)) : this.jdbcOperations.update(this.updateSql, this.sqlParameterSourceFactory.createParameterSource(message));
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap();
        map.put("UPDATED", (Object)updated2);
        return Collections.singletonList(map);
    }

    private static Message<?> payloadToMessage(final Object payload, final MessageHeaders messageHeaders) {
        if (payload instanceof Message) {
            return (Message)payload;
        }
        return new Message<Object>(){

            public Object getPayload() {
                return payload;
            }

            public MessageHeaders getHeaders() {
                return messageHeaders;
            }
        };
    }
}

