/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.support;

import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.Resource;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.codec.Codec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.dsl.support.tuple.Tuple2;
import org.springframework.integration.file.transformer.FileToByteArrayTransformer;
import org.springframework.integration.file.transformer.FileToStringTransformer;
import org.springframework.integration.json.JsonToObjectTransformer;
import org.springframework.integration.json.ObjectToJsonTransformer;
import org.springframework.integration.mail.transformer.MailToStringTransformer;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.transformer.DecodingTransformer;
import org.springframework.integration.transformer.EncodingPayloadTransformer;
import org.springframework.integration.transformer.MapToObjectTransformer;
import org.springframework.integration.transformer.ObjectToMapTransformer;
import org.springframework.integration.transformer.ObjectToStringTransformer;
import org.springframework.integration.transformer.PayloadDeserializingTransformer;
import org.springframework.integration.transformer.PayloadSerializingTransformer;
import org.springframework.integration.transformer.PayloadTypeConvertingTransformer;
import org.springframework.integration.transformer.SyslogToMapTransformer;
import org.springframework.integration.xml.result.ResultFactory;
import org.springframework.integration.xml.source.SourceFactory;
import org.springframework.integration.xml.transformer.MarshallingTransformer;
import org.springframework.integration.xml.transformer.ResultTransformer;
import org.springframework.integration.xml.transformer.SourceCreatingTransformer;
import org.springframework.integration.xml.transformer.UnmarshallingTransformer;
import org.springframework.integration.xml.transformer.XPathTransformer;
import org.springframework.integration.xml.transformer.XsltPayloadTransformer;
import org.springframework.integration.xml.xpath.XPathEvaluationType;
import org.springframework.messaging.Message;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.xml.xpath.NodeMapper;

public abstract class Transformers {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();

    public static ObjectToStringTransformer objectToString() {
        return Transformers.objectToString(null);
    }

    public static ObjectToStringTransformer objectToString(String charset) {
        return charset != null ? new ObjectToStringTransformer(charset) : new ObjectToStringTransformer();
    }

    public static ObjectToMapTransformer toMap() {
        return new ObjectToMapTransformer();
    }

    public static ObjectToMapTransformer toMap(boolean shouldFlattenKeys) {
        ObjectToMapTransformer transformer = new ObjectToMapTransformer();
        transformer.setShouldFlattenKeys(shouldFlattenKeys);
        return transformer;
    }

    public static MapToObjectTransformer fromMap(Class<?> targetClass) {
        return new MapToObjectTransformer(targetClass);
    }

    public static MapToObjectTransformer fromMap(String beanName) {
        return new MapToObjectTransformer(beanName);
    }

    public static ObjectToJsonTransformer toJson() {
        return Transformers.toJson(null, null, null);
    }

    public static ObjectToJsonTransformer toJson(JsonObjectMapper<?, ?> jsonObjectMapper) {
        return Transformers.toJson(jsonObjectMapper, null, null);
    }

    public static ObjectToJsonTransformer toJson(JsonObjectMapper<?, ?> jsonObjectMapper, ObjectToJsonTransformer.ResultType resultType) {
        return Transformers.toJson(jsonObjectMapper, resultType, null);
    }

    public static ObjectToJsonTransformer toJson(String contentType) {
        return Transformers.toJson(null, null, contentType);
    }

    public static ObjectToJsonTransformer toJson(JsonObjectMapper<?, ?> jsonObjectMapper, String contentType) {
        return Transformers.toJson(jsonObjectMapper, null, contentType);
    }

    public static ObjectToJsonTransformer toJson(ObjectToJsonTransformer.ResultType resultType, String contentType) {
        return Transformers.toJson(null, resultType, contentType);
    }

    public static ObjectToJsonTransformer toJson(JsonObjectMapper<?, ?> jsonObjectMapper, ObjectToJsonTransformer.ResultType resultType, String contentType) {
        ObjectToJsonTransformer transformer = jsonObjectMapper != null ? (resultType != null ? new ObjectToJsonTransformer(jsonObjectMapper, resultType) : new ObjectToJsonTransformer(jsonObjectMapper)) : (resultType != null ? new ObjectToJsonTransformer(resultType) : new ObjectToJsonTransformer());
        if (contentType != null) {
            transformer.setContentType(contentType);
        }
        return transformer;
    }

    public static JsonToObjectTransformer fromJson() {
        return Transformers.fromJson(null, null);
    }

    public static JsonToObjectTransformer fromJson(Class<?> targetClass) {
        return Transformers.fromJson(targetClass, null);
    }

    public static JsonToObjectTransformer fromJson(JsonObjectMapper<?, ?> jsonObjectMapper) {
        return Transformers.fromJson(null, jsonObjectMapper);
    }

    public static JsonToObjectTransformer fromJson(Class<?> targetClass, JsonObjectMapper<?, ?> jsonObjectMapper) {
        return new JsonToObjectTransformer(targetClass, jsonObjectMapper);
    }

    public static PayloadSerializingTransformer serializer() {
        return Transformers.serializer(null);
    }

    public static PayloadSerializingTransformer serializer(Serializer<Object> serializer) {
        PayloadSerializingTransformer transformer = new PayloadSerializingTransformer();
        if (serializer != null) {
            transformer.setSerializer(serializer);
        }
        return transformer;
    }

    public static PayloadDeserializingTransformer deserializer() {
        return Transformers.deserializer(null);
    }

    public static PayloadDeserializingTransformer deserializer(Deserializer<Object> deserializer) {
        PayloadDeserializingTransformer transformer = new PayloadDeserializingTransformer();
        if (deserializer != null) {
            transformer.setDeserializer(deserializer);
        }
        return transformer;
    }

    public static <T, U> PayloadTypeConvertingTransformer<T, U> converter(Converter<T, U> converter) {
        Assert.notNull(converter, (String)"The Converter<?, ?> is required for the PayloadTypeConvertingTransformer");
        PayloadTypeConvertingTransformer transformer = new PayloadTypeConvertingTransformer();
        transformer.setConverter(converter);
        return transformer;
    }

    public static SyslogToMapTransformer syslogToMap() {
        return new SyslogToMapTransformer();
    }

    public static MailToStringTransformer fromMail() {
        return Transformers.fromMail(null);
    }

    public static MailToStringTransformer fromMail(String charset) {
        MailToStringTransformer transformer = new MailToStringTransformer();
        if (charset != null) {
            transformer.setCharset(charset);
        }
        return transformer;
    }

    public static FileToStringTransformer fileToString() {
        return Transformers.fileToString(null);
    }

    public static FileToStringTransformer fileToString(String charset) {
        FileToStringTransformer transformer = new FileToStringTransformer();
        if (charset != null) {
            transformer.setCharset(charset);
        }
        return transformer;
    }

    public static FileToByteArrayTransformer fileToByteArray() {
        return new FileToByteArrayTransformer();
    }

    public static MarshallingTransformer marshaller(Marshaller marshaller) {
        return Transformers.marshaller(marshaller, null, null, null);
    }

    public static MarshallingTransformer marshaller(Marshaller marshaller, ResultTransformer resultTransformer) {
        return Transformers.marshaller(marshaller, resultTransformer, null);
    }

    public static MarshallingTransformer marshaller(Marshaller marshaller, ResultFactory resultFactory) {
        return Transformers.marshaller(marshaller, null, resultFactory);
    }

    public static MarshallingTransformer marshaller(Marshaller marshaller, boolean extractPayload) {
        return Transformers.marshaller(marshaller, null, null, extractPayload);
    }

    public static MarshallingTransformer marshaller(Marshaller marshaller, ResultFactory resultFactory, boolean extractPayload) {
        return Transformers.marshaller(marshaller, null, resultFactory, extractPayload);
    }

    public static MarshallingTransformer marshaller(Marshaller marshaller, ResultTransformer resultTransformer, boolean extractPayload) {
        return Transformers.marshaller(marshaller, resultTransformer, null, extractPayload);
    }

    public static MarshallingTransformer marshaller(Marshaller marshaller, ResultTransformer resultTransformer, ResultFactory resultFactory) {
        return Transformers.marshaller(marshaller, resultTransformer, resultFactory, null);
    }

    public static MarshallingTransformer marshaller(Marshaller marshaller, ResultTransformer resultTransformer, ResultFactory resultFactory, boolean extractPayload) {
        return Transformers.marshaller(marshaller, resultTransformer, resultFactory, (Boolean)extractPayload);
    }

    private static MarshallingTransformer marshaller(Marshaller marshaller, ResultTransformer resultTransformer, ResultFactory resultFactory, Boolean extractPayload) {
        try {
            MarshallingTransformer transformer = new MarshallingTransformer(marshaller, resultTransformer);
            if (resultFactory != null) {
                transformer.setResultFactory(resultFactory);
            }
            if (extractPayload != null) {
                transformer.setExtractPayload(extractPayload.booleanValue());
            }
            return transformer;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static UnmarshallingTransformer unmarshaller(Unmarshaller unmarshaller) {
        return Transformers.unmarshaller(unmarshaller, null);
    }

    public static UnmarshallingTransformer unmarshaller(Unmarshaller unmarshaller, SourceFactory sourceFactory) {
        return Transformers.unmarshaller(unmarshaller, sourceFactory, false);
    }

    public static UnmarshallingTransformer unmarshaller(Unmarshaller unmarshaller, boolean alwaysUseSourceFactory) {
        return Transformers.unmarshaller(unmarshaller, null, alwaysUseSourceFactory);
    }

    public static UnmarshallingTransformer unmarshaller(Unmarshaller unmarshaller, SourceFactory sourceFactory, boolean alwaysUseSourceFactory) {
        UnmarshallingTransformer transformer = new UnmarshallingTransformer(unmarshaller);
        if (sourceFactory != null) {
            transformer.setSourceFactory(sourceFactory);
        }
        transformer.setAlwaysUseSourceFactory(alwaysUseSourceFactory);
        return transformer;
    }

    public static SourceCreatingTransformer xmlSource() {
        return Transformers.xmlSource(null);
    }

    public static SourceCreatingTransformer xmlSource(SourceFactory sourceFactory) {
        return sourceFactory != null ? new SourceCreatingTransformer(sourceFactory) : new SourceCreatingTransformer();
    }

    public static XPathTransformer xpath(String xpathExpression) {
        return Transformers.xpath(xpathExpression, null, null);
    }

    public static XPathTransformer xpath(String xpathExpression, XPathEvaluationType xpathEvaluationType) {
        return Transformers.xpath(xpathExpression, xpathEvaluationType, null);
    }

    public static XPathTransformer xpath(String xpathExpression, NodeMapper<?> nodeMapper) {
        return Transformers.xpath(xpathExpression, null, nodeMapper);
    }

    public static XPathTransformer xpath(String xpathExpression, XPathEvaluationType xpathEvaluationType, NodeMapper<?> nodeMapper) {
        XPathTransformer transformer = new XPathTransformer(xpathExpression);
        if (xpathEvaluationType != null) {
            transformer.setEvaluationType(xpathEvaluationType);
        }
        if (nodeMapper != null) {
            transformer.setNodeMapper(nodeMapper);
        }
        return transformer;
    }

    @SafeVarargs
    public static XsltPayloadTransformer xslt(Resource xsltTemplate, Tuple2<String, Expression> ... xslParameterMappings) {
        XsltPayloadTransformer transformer = new XsltPayloadTransformer(xsltTemplate);
        if (xslParameterMappings != null) {
            HashMap params = new HashMap(xslParameterMappings.length);
            for (Tuple2<String, Expression> mapping : xslParameterMappings) {
                params.put(mapping.getT1(), mapping.getT2());
            }
            transformer.setXslParameterMappings(params);
        }
        return transformer;
    }

    public static <T> EncodingPayloadTransformer<T> encoding(Codec codec) {
        return new EncodingPayloadTransformer(codec);
    }

    public static <T> DecodingTransformer<T> decoding(Codec codec, Class<T> type) {
        return new DecodingTransformer(codec, type);
    }

    public static <T> DecodingTransformer<T> decoding(Codec codec, String typeExpression) {
        return Transformers.decoding(codec, PARSER.parseExpression(typeExpression));
    }

    public static <T> DecodingTransformer<T> decoding(Codec codec, Function<Message<?>, Class<T>> typeFunction) {
        return Transformers.decoding(codec, new FunctionExpression(typeFunction));
    }

    public static <T> DecodingTransformer<T> decoding(Codec codec, Expression typeExpression) {
        return new DecodingTransformer(codec, typeExpression);
    }
}

