/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.mail;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.dsl.support.PropertiesBuilder;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.integration.mail.MailReceivingMessageSource;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.util.Assert;

public abstract class MailInboundChannelAdapterSpec<S extends MailInboundChannelAdapterSpec<S, R>, R extends AbstractMailReceiver>
extends MessageSourceSpec<S, MailReceivingMessageSource>
implements ComponentsRegistration {
    protected final R receiver;
    protected final boolean externalReceiver;
    private boolean sessionProvided;

    protected MailInboundChannelAdapterSpec(R receiver) {
        this(receiver, false);
    }

    protected MailInboundChannelAdapterSpec(R receiver, boolean externalReceiver) {
        this.receiver = receiver;
        this.externalReceiver = externalReceiver;
    }

    public S selectorExpression(String selectorExpression) {
        this.assertReceiver();
        this.receiver.setSelectorExpression(PARSER.parseExpression(selectorExpression));
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    protected void assertReceiver() {
        Assert.state((!this.externalReceiver ? 1 : 0) != 0, (String)("An external 'receiver' [" + this.receiver + "] can't be modified."));
    }

    public S selectorExpression(Expression selectorExpression) {
        this.assertReceiver();
        this.receiver.setSelectorExpression(selectorExpression);
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    public S selector(Function<MimeMessage, Boolean> selectorFunction) {
        this.assertReceiver();
        this.receiver.setSelectorExpression(new FunctionExpression<MimeMessage>(selectorFunction));
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    public S session(Session session) {
        this.assertReceiver();
        this.receiver.setSession(session);
        this.sessionProvided = true;
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    public S javaMailProperties(Properties javaMailProperties) {
        this.assertReceiver();
        this.assertSession();
        this.receiver.setJavaMailProperties(javaMailProperties);
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    private void assertSession() {
        Assert.state((!this.sessionProvided ? 1 : 0) != 0, (String)"Neither 'javaMailProperties' nor 'javaMailAuthenticator' references are allowed when a 'session' reference has been provided.");
    }

    public S javaMailProperties(Consumer<PropertiesBuilder> configurer) {
        PropertiesBuilder properties = new PropertiesBuilder();
        configurer.accept(properties);
        return this.javaMailProperties(properties.get());
    }

    public S javaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.assertSession();
        this.assertReceiver();
        this.receiver.setJavaMailAuthenticator(javaMailAuthenticator);
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    public S maxFetchSize(int maxFetchSize) {
        this.assertReceiver();
        this.receiver.setMaxFetchSize(maxFetchSize);
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    public S shouldDeleteMessages(boolean shouldDeleteMessages) {
        this.assertReceiver();
        this.receiver.setShouldDeleteMessages(shouldDeleteMessages);
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    public S userFlag(String userFlag) {
        this.assertReceiver();
        this.receiver.setUserFlag(userFlag);
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    public S headerMapper(HeaderMapper<MimeMessage> headerMapper) {
        this.assertReceiver();
        this.receiver.setHeaderMapper(headerMapper);
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    public S embeddedPartsAsBytes(boolean embeddedPartsAsBytes) {
        this.assertReceiver();
        this.receiver.setEmbeddedPartsAsBytes(embeddedPartsAsBytes);
        return (S)((MailInboundChannelAdapterSpec)this._this());
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        return Collections.singletonList(this.receiver);
    }

    @Override
    public MailReceivingMessageSource doGet() {
        return new MailReceivingMessageSource(this.receiver);
    }
}

