/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.kafka;

import java.util.Collection;
import java.util.Collections;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.kafka.outbound.KafkaProducerMessageHandler;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.Message;

public class KafkaProducerMessageHandlerSpec<K, V>
extends MessageHandlerSpec<KafkaProducerMessageHandlerSpec<K, V>, KafkaProducerMessageHandler<K, V>> {
    protected final KafkaTemplate<K, V> kafkaTemplate;

    KafkaProducerMessageHandlerSpec(KafkaTemplate<K, V> kafkaTemplate) {
        this.target = new KafkaProducerMessageHandler(kafkaTemplate);
        this.kafkaTemplate = kafkaTemplate;
    }

    public KafkaProducerMessageHandlerSpec<K, V> topic(String topic) {
        return this.topicExpression((Expression)new LiteralExpression(topic));
    }

    public KafkaProducerMessageHandlerSpec<K, V> topicExpression(String topicExpression) {
        return this.topicExpression(PARSER.parseExpression(topicExpression));
    }

    public KafkaProducerMessageHandlerSpec<K, V> topicExpression(Expression topicExpression) {
        ((KafkaProducerMessageHandler)this.target).setTopicExpression(topicExpression);
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public <P> KafkaProducerMessageHandlerSpec<K, V> topic(Function<Message<P>, String> topicFunction) {
        return this.topicExpression(new FunctionExpression<Message<P>>(topicFunction));
    }

    public KafkaProducerMessageHandlerSpec<K, V> messageKeyExpression(String messageKeyExpression) {
        return this.messageKeyExpression(PARSER.parseExpression(messageKeyExpression));
    }

    public KafkaProducerMessageHandlerSpec<K, V> messageKey(String messageKey) {
        return this.messageKeyExpression((Expression)new LiteralExpression(messageKey));
    }

    public KafkaProducerMessageHandlerSpec<K, V> messageKeyExpression(Expression messageKeyExpression) {
        ((KafkaProducerMessageHandler)this.target).setMessageKeyExpression(messageKeyExpression);
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public <P> KafkaProducerMessageHandlerSpec<K, V> messageKey(Function<Message<P>, ?> messageKeyFunction) {
        return this.messageKeyExpression(new FunctionExpression<Message<P>>(messageKeyFunction));
    }

    public KafkaProducerMessageHandlerSpec<K, V> partitionId(Integer partitionId) {
        return this.partitionIdExpression((Expression)new ValueExpression((Object)partitionId));
    }

    public KafkaProducerMessageHandlerSpec<K, V> partitionIdExpression(String partitionIdExpression) {
        return this.partitionIdExpression(PARSER.parseExpression(partitionIdExpression));
    }

    public <P> KafkaProducerMessageHandlerSpec<K, V> partitionId(Function<Message<P>, Integer> partitionIdFunction) {
        return this.partitionIdExpression(new FunctionExpression<Message<P>>(partitionIdFunction));
    }

    public KafkaProducerMessageHandlerSpec<K, V> partitionIdExpression(Expression partitionIdExpression) {
        ((KafkaProducerMessageHandler)this.target).setPartitionIdExpression(partitionIdExpression);
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public KafkaProducerMessageHandlerSpec<K, V> sync(boolean sync) {
        ((KafkaProducerMessageHandler)this.target).setSync(sync);
        return this;
    }

    public KafkaProducerMessageHandlerSpec<K, V> sendTimeout(long sendTimeout) {
        ((KafkaProducerMessageHandler)this.target).setSendTimeout(sendTimeout);
        return this;
    }

    public static class KafkaProducerMessageHandlerTemplateSpec<K, V>
    extends KafkaProducerMessageHandlerSpec<K, V>
    implements ComponentsRegistration {
        KafkaProducerMessageHandlerTemplateSpec(ProducerFactory<K, V> producerFactory) {
            super(new KafkaTemplate(producerFactory));
        }

        public KafkaProducerMessageHandlerTemplateSpec<K, V> producerListener(ProducerListener<K, V> producerListener) {
            this.kafkaTemplate.setProducerListener(producerListener);
            return this;
        }

        public KafkaProducerMessageHandlerTemplateSpec<K, V> messageConverter(RecordMessageConverter messageConverter) {
            this.kafkaTemplate.setMessageConverter(messageConverter);
            return this;
        }

        @Override
        public Collection<Object> getComponentsToRegister() {
            return Collections.singleton(this.kafkaTemplate);
        }
    }
}

