/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.file;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizingMessageSource;

public abstract class RemoteFileInboundChannelAdapterSpec<F, S extends RemoteFileInboundChannelAdapterSpec<F, S, MS>, MS extends AbstractInboundFileSynchronizingMessageSource<F>>
extends MessageSourceSpec<S, MS>
implements ComponentsRegistration {
    protected final AbstractInboundFileSynchronizer<F> synchronizer;
    private CompositeFileListFilter<F> filter;

    protected RemoteFileInboundChannelAdapterSpec(AbstractInboundFileSynchronizer<F> synchronizer) {
        this.synchronizer = synchronizer;
    }

    public S autoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        ((AbstractInboundFileSynchronizingMessageSource)this.target).setAutoCreateLocalDirectory(autoCreateLocalDirectory);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public S localDirectory(File localDirectory) {
        ((AbstractInboundFileSynchronizingMessageSource)this.target).setLocalDirectory(localDirectory);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public S localFilter(FileListFilter<File> localFileListFilter) {
        ((AbstractInboundFileSynchronizingMessageSource)this.target).setLocalFilter(localFileListFilter);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public S remoteFileSeparator(String remoteFileSeparator) {
        this.synchronizer.setRemoteFileSeparator(remoteFileSeparator);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public S localFilenameExpression(String localFilenameExpression) {
        return this.localFilenameExpression(PARSER.parseExpression(localFilenameExpression));
    }

    public S localFilename(Function<String, String> localFilenameFunction) {
        return this.localFilenameExpression(new FunctionExpression<String>(localFilenameFunction));
    }

    public S localFilenameExpression(Expression localFilenameExpression) {
        this.synchronizer.setLocalFilenameGeneratorExpression(localFilenameExpression);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public S temporaryFileSuffix(String temporaryFileSuffix) {
        this.synchronizer.setTemporaryFileSuffix(temporaryFileSuffix);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public S remoteDirectory(String remoteDirectory) {
        this.synchronizer.setRemoteDirectory(remoteDirectory);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public S remoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.synchronizer.setRemoteDirectoryExpression(remoteDirectoryExpression);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public S filter(FileListFilter<F> filter) {
        if (this.filter == null) {
            if (filter instanceof CompositeFileListFilter) {
                this.filter = (CompositeFileListFilter)filter;
            } else {
                this.filter = new CompositeFileListFilter();
                this.filter.addFilter(filter);
            }
            this.synchronizer.setFilter(this.filter);
        } else {
            this.filter.addFilter(filter);
        }
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public abstract S patternFilter(String var1);

    public abstract S regexFilter(String var1);

    public S deleteRemoteFiles(boolean deleteRemoteFiles) {
        this.synchronizer.setDeleteRemoteFiles(deleteRemoteFiles);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    public S preserveTimestamp(boolean preserveTimestamp) {
        this.synchronizer.setPreserveTimestamp(preserveTimestamp);
        return (S)((RemoteFileInboundChannelAdapterSpec)this._this());
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        return Collections.singletonList(this.synchronizer);
    }
}

