/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.expression.Expression;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.dsl.AbstractRouterSpec;
import org.springframework.integration.dsl.DslRecipientListRouter;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.router.RecipientListRouter;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RecipientListRouterSpec
extends AbstractRouterSpec<RecipientListRouterSpec, RecipientListRouter> {
    RecipientListRouterSpec() {
        super(new DslRecipientListRouter());
    }

    public RecipientListRouterSpec recipient(String channelName) {
        return this.recipient(channelName, (String)null);
    }

    public RecipientListRouterSpec recipient(String channelName, String expression) {
        return this.recipient(channelName, StringUtils.hasText((String)expression) ? PARSER.parseExpression(expression) : null);
    }

    public RecipientListRouterSpec recipient(String channelName, Expression expression) {
        Assert.hasText((String)channelName, (String)"'channelName' must not be empty");
        ((DslRecipientListRouter)((Object)this.target)).add(channelName, expression);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipient(String channelName, MessageSelector selector) {
        return this.recipient(channelName, (GenericSelector)selector);
    }

    public <P> RecipientListRouterSpec recipient(String channelName, GenericSelector<P> selector) {
        Assert.hasText((String)channelName, (String)"'channelName' must not be empty");
        ((DslRecipientListRouter)((Object)this.target)).add(channelName, selector);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipient(MessageChannel channel) {
        return this.recipient(channel, (String)null);
    }

    public RecipientListRouterSpec recipient(MessageChannel channel, String expression) {
        return this.recipient(channel, StringUtils.hasText((String)expression) ? PARSER.parseExpression(expression) : null);
    }

    public RecipientListRouterSpec recipient(MessageChannel channel, Expression expression) {
        Assert.notNull((Object)channel, (String)"'channel' must not be null");
        ((DslRecipientListRouter)((Object)this.target)).add(channel, expression);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipient(MessageChannel channel, MessageSelector selector) {
        return this.recipient(channel, (GenericSelector)selector);
    }

    public <P> RecipientListRouterSpec recipient(MessageChannel channel, GenericSelector<P> selector) {
        Assert.notNull((Object)channel, (String)"'channel' must not be null");
        ((DslRecipientListRouter)((Object)this.target)).add(channel, selector);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipientFlow(MessageSelector selector, IntegrationFlow subFlow) {
        return this.recipientFlow((GenericSelector)selector, subFlow);
    }

    public <P> RecipientListRouterSpec recipientFlow(GenericSelector<P> selector, IntegrationFlow subFlow) {
        Assert.notNull((Object)subFlow, (String)"'subFlow' must not be null");
        DirectChannel channel = this.populateSubFlow(subFlow);
        ((DslRecipientListRouter)((Object)this.target)).add((MessageChannel)channel, selector);
        return (RecipientListRouterSpec)this._this();
    }

    public RecipientListRouterSpec recipientFlow(IntegrationFlow subFlow) {
        return this.recipientFlow((String)null, subFlow);
    }

    public RecipientListRouterSpec recipientFlow(String expression, IntegrationFlow subFlow) {
        return this.recipientFlow(StringUtils.hasText((String)expression) ? PARSER.parseExpression(expression) : null, subFlow);
    }

    public RecipientListRouterSpec recipientFlow(Expression expression, IntegrationFlow subFlow) {
        Assert.notNull((Object)subFlow, (String)"'subFlow' must not be null");
        DirectChannel channel = this.populateSubFlow(subFlow);
        ((DslRecipientListRouter)((Object)this.target)).add((MessageChannel)channel, expression);
        return (RecipientListRouterSpec)this._this();
    }

    private DirectChannel populateSubFlow(IntegrationFlow subFlow) {
        DirectChannel channel = new DirectChannel();
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from((MessageChannel)channel);
        subFlow.configure(flowBuilder);
        this.subFlows.add(flowBuilder.get());
        return channel;
    }
}

