/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.integration.aggregator.BarrierMessageHandler;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.HeaderAttributeCorrelationStrategy;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.dsl.core.ConsumerEndpointSpec;
import org.springframework.integration.dsl.support.tuple.Tuple2;
import org.springframework.integration.dsl.support.tuple.Tuples;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;

public class BarrierSpec
extends ConsumerEndpointSpec<BarrierSpec, BarrierMessageHandler> {
    private final long timeout;
    private MessageGroupProcessor outputProcessor = new DefaultAggregatingMessageGroupProcessor();
    private CorrelationStrategy correlationStrategy = new HeaderAttributeCorrelationStrategy("correlationId");
    private boolean requiresReply;
    private long sendTimeout = -1L;
    private int order = Integer.MAX_VALUE;
    private boolean async;

    BarrierSpec(long timeout) {
        super(null);
        this.timeout = timeout;
    }

    public BarrierSpec outputProcessor(MessageGroupProcessor outputProcessor) {
        Assert.notNull((Object)outputProcessor, (String)"'outputProcessor' must not be null.");
        this.outputProcessor = outputProcessor;
        return this;
    }

    public BarrierSpec correlationStrategy(CorrelationStrategy correlationStrategy) {
        Assert.notNull((Object)correlationStrategy, (String)"'correlationStrategy' must not be null.");
        this.correlationStrategy = correlationStrategy;
        return this;
    }

    @Override
    public BarrierSpec requiresReply(boolean requiresReply) {
        this.requiresReply = requiresReply;
        return this;
    }

    @Override
    public BarrierSpec sendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
        return this;
    }

    @Override
    public BarrierSpec order(int order) {
        this.order = order;
        return this;
    }

    @Override
    public BarrierSpec async(boolean async) {
        this.async = async;
        return this;
    }

    @Override
    public Tuple2<ConsumerEndpointFactoryBean, BarrierMessageHandler> doGet() {
        BarrierMessageHandler barrierMessageHandler = new BarrierMessageHandler(this.timeout, this.outputProcessor, this.correlationStrategy);
        barrierMessageHandler.setAdviceChain(this.adviceChain);
        barrierMessageHandler.setRequiresReply(this.requiresReply);
        barrierMessageHandler.setSendTimeout(this.sendTimeout);
        barrierMessageHandler.setAsync(this.async);
        barrierMessageHandler.setOrder(this.order);
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setHandler((MessageHandler)barrierMessageHandler);
        return Tuples.of(this.endpointFactoryBean, barrierMessageHandler);
    }
}

