/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import org.springframework.integration.ip.tcp.serializer.ByteArrayCrLfSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLengthHeaderSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayLfSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayRawSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArraySingleTerminatorSerializer;
import org.springframework.integration.ip.tcp.serializer.ByteArrayStxEtxSerializer;

public final class TcpCodecs {
    private static ByteArrayLengthHeaderSerializer oneByteLHS;
    private static ByteArrayLengthHeaderSerializer twoByteLHS;
    private static ByteArrayLengthHeaderSerializer fourByteLHS;

    private TcpCodecs() {
    }

    public static ByteArrayCrLfSerializer crlf() {
        return ByteArrayCrLfSerializer.INSTANCE;
    }

    public static ByteArrayLfSerializer lf() {
        return ByteArrayLfSerializer.INSTANCE;
    }

    public static ByteArrayRawSerializer raw() {
        return ByteArrayRawSerializer.INSTANCE;
    }

    public static ByteArrayStxEtxSerializer stxetx() {
        return ByteArrayStxEtxSerializer.INSTANCE;
    }

    public static ByteArraySingleTerminatorSerializer singleTerminator(byte terminator) {
        return new ByteArraySingleTerminatorSerializer(terminator);
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader1() {
        if (oneByteLHS == null) {
            oneByteLHS = new ByteArrayLengthHeaderSerializer(1);
        }
        return oneByteLHS;
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader2() {
        if (twoByteLHS == null) {
            twoByteLHS = new ByteArrayLengthHeaderSerializer(2);
        }
        return twoByteLHS;
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader4() {
        if (fourByteLHS == null) {
            fourByteLHS = new ByteArrayLengthHeaderSerializer(4);
        }
        return fourByteLHS;
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader(int bytes) {
        return switch (bytes) {
            case 1 -> TcpCodecs.lengthHeader1();
            case 2 -> TcpCodecs.lengthHeader2();
            case 4 -> TcpCodecs.lengthHeader4();
            default -> throw new IllegalArgumentException("Only 1, 2 or 4 byte headers are supported");
        };
    }

    public static ByteArrayCrLfSerializer crlf(int maxMessageSize) {
        ByteArrayCrLfSerializer codec = new ByteArrayCrLfSerializer();
        codec.setMaxMessageSize(maxMessageSize);
        return codec;
    }

    public static ByteArrayLfSerializer lf(int maxMessageSize) {
        ByteArrayLfSerializer codec = new ByteArrayLfSerializer();
        codec.setMaxMessageSize(maxMessageSize);
        return codec;
    }

    public static ByteArrayRawSerializer raw(int maxMessageSize) {
        ByteArrayRawSerializer codec = new ByteArrayRawSerializer();
        codec.setMaxMessageSize(maxMessageSize);
        return codec;
    }

    public static ByteArrayStxEtxSerializer stxetx(int maxMessageSize) {
        ByteArrayStxEtxSerializer codec = new ByteArrayStxEtxSerializer();
        codec.setMaxMessageSize(maxMessageSize);
        return codec;
    }

    public static ByteArraySingleTerminatorSerializer singleTerminator(byte terminator, int maxMessageSize) {
        ByteArraySingleTerminatorSerializer codec = new ByteArraySingleTerminatorSerializer(terminator);
        codec.setMaxMessageSize(maxMessageSize);
        return codec;
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader1(int maxMessageSize) {
        ByteArrayLengthHeaderSerializer codec = new ByteArrayLengthHeaderSerializer(1);
        codec.setMaxMessageSize(maxMessageSize);
        return codec;
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader2(int maxMessageSize) {
        ByteArrayLengthHeaderSerializer codec = new ByteArrayLengthHeaderSerializer(2);
        codec.setMaxMessageSize(maxMessageSize);
        return codec;
    }

    public static ByteArrayLengthHeaderSerializer lengthHeader4(int maxMessageSize) {
        ByteArrayLengthHeaderSerializer codec = new ByteArrayLengthHeaderSerializer(4);
        codec.setMaxMessageSize(maxMessageSize);
        return codec;
    }
}

