/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.util.FileCopyUtils;

public class SerializingHttpMessageConverter
extends AbstractHttpMessageConverter<Serializable> {
    private static final MediaType APPLICATION_JAVA_SERIALIZED_OBJECT = new MediaType("application", "x-java-serialized-object");

    public SerializingHttpMessageConverter() {
        super(APPLICATION_JAVA_SERIALIZED_OBJECT);
    }

    public boolean supports(Class<?> clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return Serializable.class.isAssignableFrom(clazz) && this.canWrite(mediaType);
    }

    public Serializable readInternal(Class clazz, HttpInputMessage inputMessage) throws IOException {
        try {
            return (Serializable)new ObjectInputStream(inputMessage.getBody()).readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void writeInternal(Serializable object, HttpOutputMessage outputMessage) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
        objectStream.writeObject(object);
        objectStream.flush();
        objectStream.close();
        byte[] bytes = byteStream.toByteArray();
        FileCopyUtils.copy((byte[])bytes, (OutputStream)outputMessage.getBody());
    }
}

