/*
 * Copyright 2002-2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.http.multipart;

import java.io.IOException;

import org.springframework.web.multipart.MultipartFile;

/**
 * Strategy for reading {@link MultipartFile} content.
 *
 * @author Mark Fisher
 *
 * @since 2.0
 */
public interface MultipartFileReader<T> {

	/**
	 * Reads {@link MultipartFile} content.
	 *
	 * @param multipartFile The multipart file.
	 * @return The result of reading the file.
	 * @throws IOException Any IOException.
	 */
	T readMultipartFile(MultipartFile multipartFile) throws IOException;

}
