/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.inbound;

import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.SqlPredicate;
import java.util.Collection;
import java.util.Collections;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.hazelcast.DistributedSQLIterationType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class HazelcastDistributedSQLMessageSource
extends AbstractMessageSource {
    private final IMap<?, ?> distributedMap;
    private final String distributedSql;
    private DistributedSQLIterationType iterationType = DistributedSQLIterationType.VALUE;

    public HazelcastDistributedSQLMessageSource(IMap distributedMap, String distributedSql) {
        Assert.notNull((Object)distributedMap, (String)"'distributedMap' must not be null");
        Assert.hasText((String)distributedSql, (String)"'distributedSql' must not be empty");
        this.distributedMap = distributedMap;
        this.distributedSql = distributedSql;
    }

    public void setIterationType(DistributedSQLIterationType iterationType) {
        Assert.notNull((Object)((Object)this.iterationType), (String)"'iterationType' must not be null");
        this.iterationType = iterationType;
    }

    public String getComponentType() {
        return "hazelcast:ds-inbound-channel-adapter";
    }

    protected Collection<?> doReceive() {
        Collection collection;
        SqlPredicate predicate = new SqlPredicate(this.distributedSql);
        switch (this.iterationType) {
            case ENTRY: {
                Collection collection2 = this.distributedMap.entrySet((Predicate)predicate);
                break;
            }
            case KEY: {
                Collection collection2 = this.distributedMap.keySet((Predicate)predicate);
                break;
            }
            case LOCAL_KEY: {
                Collection collection2 = this.distributedMap.localKeySet((Predicate)predicate);
                break;
            }
            default: {
                Collection collection2 = collection = this.distributedMap.values((Predicate)predicate);
            }
        }
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return null;
        }
        return Collections.unmodifiableCollection(collection);
    }
}

