/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.inbound;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.SqlPredicate;
import org.springframework.integration.hazelcast.inbound.AbstractHazelcastMessageProducer;
import org.springframework.util.Assert;

public class HazelcastContinuousQueryMessageProducer
extends AbstractHazelcastMessageProducer {
    private final String predicate;
    private boolean includeValue = true;

    public HazelcastContinuousQueryMessageProducer(IMap distributedMap, String predicate) {
        super((DistributedObject)distributedMap);
        Assert.hasText((String)predicate, (String)"'predicate' must not be null");
        this.predicate = predicate;
    }

    public void setIncludeValue(boolean includeValue) {
        this.includeValue = includeValue;
    }

    protected void doStart() {
        this.setHazelcastRegisteredEventListenerId(((IMap)this.distributedObject).addEntryListener(new AbstractHazelcastMessageProducer.HazelcastEntryListener(this), (Predicate)new SqlPredicate(this.predicate), this.includeValue));
    }

    protected void doStop() {
        ((IMap)this.distributedObject).removeEntryListener(this.getHazelcastRegisteredEventListenerId());
    }

    public String getComponentType() {
        return "hazelcast:cq-inbound-channel-adapter";
    }
}

