/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.amqp.support.MappingUtils;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public abstract class AbstractAmqpChannel
extends AbstractMessageChannel
implements ConnectionListener {
    private final AmqpTemplate amqpTemplate;
    private final RabbitTemplate rabbitTemplate;
    private final AmqpHeaderMapper outboundHeaderMapper;
    private final AmqpHeaderMapper inboundHeaderMapper;
    private AmqpAdmin admin;
    private ConnectionFactory connectionFactory;
    private boolean extractPayload;
    private boolean loggingEnabled = true;
    private MessageDeliveryMode defaultDeliveryMode;
    private boolean headersMappedLast;
    private volatile boolean initialized;

    AbstractAmqpChannel(AmqpTemplate amqpTemplate) {
        this(amqpTemplate, DefaultAmqpHeaderMapper.outboundMapper(), DefaultAmqpHeaderMapper.inboundMapper());
    }

    AbstractAmqpChannel(AmqpTemplate amqpTemplate, AmqpHeaderMapper outboundMapper, AmqpHeaderMapper inboundMapper) {
        Assert.notNull((Object)amqpTemplate, (String)"amqpTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
        this.rabbitTemplate = amqpTemplate instanceof RabbitTemplate ? (RabbitTemplate)amqpTemplate : null;
        this.outboundHeaderMapper = outboundMapper;
        this.inboundHeaderMapper = inboundMapper;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public void setDefaultDeliveryMode(MessageDeliveryMode defaultDeliveryMode) {
        this.defaultDeliveryMode = defaultDeliveryMode;
    }

    public void setExtractPayload(boolean extractPayload) {
        if (extractPayload) {
            Assert.isTrue((this.rabbitTemplate != null ? 1 : 0) != 0, (String)"amqpTemplate must be a RabbitTemplate for 'extractPayload'");
            Assert.state((this.outboundHeaderMapper != null && this.inboundHeaderMapper != null ? 1 : 0) != 0, (String)"'extractPayload' requires both inbound and outbound header mappers");
        }
        this.extractPayload = extractPayload;
    }

    protected boolean isExtractPayload() {
        return this.extractPayload;
    }

    public void setHeadersMappedLast(boolean headersMappedLast) {
        this.headersMappedLast = headersMappedLast;
    }

    protected String getExchangeName() {
        return "";
    }

    protected String getRoutingKey() {
        return "";
    }

    protected AmqpHeaderMapper getInboundHeaderMapper() {
        return this.inboundHeaderMapper;
    }

    protected AmqpTemplate getAmqpTemplate() {
        return this.amqpTemplate;
    }

    protected RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    protected final void setAdmin(AmqpAdmin admin) {
        this.admin = admin;
    }

    protected final void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected AmqpAdmin getAdmin() {
        return this.admin;
    }

    protected ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected void onInit() {
        super.onInit();
        if (!this.initialized && this.rabbitTemplate != null && this.connectionFactory != null) {
            this.connectionFactory.addConnectionListener((ConnectionListener)this);
        }
        this.initialized = true;
    }

    public void destroy() {
        if (this.connectionFactory != null) {
            this.connectionFactory.removeConnectionListener((ConnectionListener)this);
            this.initialized = false;
        }
    }

    protected boolean doSend(Message<?> message, long timeout) {
        if (this.extractPayload) {
            this.amqpTemplate.send(this.getExchangeName(), this.getRoutingKey(), MappingUtils.mapMessage(message, this.rabbitTemplate.getMessageConverter(), this.outboundHeaderMapper, this.defaultDeliveryMode, this.headersMappedLast));
        } else {
            this.amqpTemplate.convertAndSend(this.getExchangeName(), this.getRoutingKey(), message);
        }
        return true;
    }

    public void onCreate(Connection connection) {
        this.doDeclares();
    }

    public void onClose(Connection connection) {
    }

    protected abstract void doDeclares();
}

