/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.util.Assert;

public class RepresentationModel<T extends RepresentationModel<? extends T>> {
    private List<Link> links;

    public RepresentationModel() {
        this.links = new ArrayList<Link>();
    }

    public RepresentationModel(Link initialLink) {
        Assert.notNull((Object)initialLink, (String)"initialLink must not be null!");
        this.links = new ArrayList<Link>();
        this.links.add(initialLink);
    }

    public RepresentationModel(Iterable<Link> initialLinks) {
        Assert.notNull(initialLinks, (String)"initialLinks must not be null!");
        this.links = new ArrayList<Link>();
        for (Link link : initialLinks) {
            this.links.add(link);
        }
    }

    public static <T> RepresentationModel<?> of(@Nullable T object) {
        return RepresentationModel.of(object, Collections.emptyList());
    }

    public static <T> RepresentationModel<?> of(@Nullable T object, Iterable<Link> links) {
        if (object == null) {
            return new RepresentationModel<T>(links);
        }
        if (Collection.class.isInstance(object)) {
            return CollectionModel.of((Collection)object, links);
        }
        return EntityModel.of(object, links);
    }

    public T add(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        this.links.add(link);
        return (T)this;
    }

    public T add(Iterable<Link> links) {
        Assert.notNull(links, (String)"Given links must not be null!");
        links.forEach(this::add);
        return (T)this;
    }

    public T add(Link ... links) {
        Assert.notNull((Object)links, (String)"Given links must not be null!");
        this.add(Arrays.asList(links));
        return (T)this;
    }

    public T addIf(boolean guard, Supplier<Link> link) {
        if (guard) {
            this.add(link.get());
        }
        return (T)this;
    }

    public T addAllIf(boolean guard, Supplier<? extends Iterable<Link>> links) {
        if (guard) {
            this.add(links.get());
        }
        return (T)this;
    }

    public boolean hasLinks() {
        return !this.links.isEmpty();
    }

    public boolean hasLink(String rel) {
        return this.getLink(rel).isPresent();
    }

    public boolean hasLink(LinkRelation rel) {
        return this.hasLink(rel.value());
    }

    @JsonProperty
    public Links getLinks() {
        return Links.of(this.links);
    }

    public T removeLinks() {
        this.links.clear();
        return (T)this;
    }

    public Optional<Link> getLink(String relation) {
        return this.getLink(LinkRelation.of(relation));
    }

    public Optional<Link> getLink(LinkRelation relation) {
        return this.links.stream().filter(it -> it.hasRel(relation)).findFirst();
    }

    public Link getRequiredLink(String relation) {
        return this.getLink(relation).orElseThrow(() -> new IllegalArgumentException(String.format("No link with rel %s found!", relation)));
    }

    public Link getRequiredLink(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        return this.getRequiredLink(relation.value());
    }

    public List<Link> getLinks(String relation) {
        Assert.hasText((String)relation, (String)"Link relation must not be null or empty!");
        return this.links.stream().filter(link -> link.hasRel(relation)).collect(Collectors.toList());
    }

    public List<Link> getLinks(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        return this.getLinks(relation.value());
    }

    public T mapLink(LinkRelation relation, Function<Link, Link> mapper) {
        return this.mapLinkIf(true, relation, mapper);
    }

    public T mapLinkIf(boolean condition, LinkRelation relation, Function<Link, Link> mapper) {
        if (!condition) {
            return (T)this;
        }
        this.getLinks(relation).forEach(it -> {
            this.links.remove(it);
            this.links.add((Link)mapper.apply((Link)it));
        });
        return (T)this;
    }

    public String toString() {
        return String.format("links: %s", this.links.toString());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        RepresentationModel that = (RepresentationModel)obj;
        return this.getLinks().equals(that.getLinks());
    }

    public int hashCode() {
        return this.links.hashCode();
    }
}

