/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SlicedModel<T>
extends CollectionModel<T> {
    public static SlicedModel<?> NO_SLICE = new SlicedModel();
    private final SliceMetadata metadata;
    @Nullable
    private final ResolvableType fallbackType;

    protected SlicedModel() {
        this(new ArrayList(), null);
    }

    protected SlicedModel(Collection<T> content, @Nullable SliceMetadata metadata) {
        this(content, metadata, Links.NONE);
    }

    protected SlicedModel(Collection<T> content, @Nullable SliceMetadata metadata, Iterable<Link> links) {
        this(content, metadata, links, null);
    }

    protected SlicedModel(Collection<T> content, @Nullable SliceMetadata metadata, Iterable<Link> links, @Nullable ResolvableType fallbackType) {
        super(content, links, fallbackType);
        this.metadata = metadata;
        this.fallbackType = fallbackType;
    }

    public static <T> SlicedModel<T> empty() {
        return SlicedModel.empty(Collections.emptyList());
    }

    public static <T> SlicedModel<T> empty(Class<T> fallbackElementType, Class<?> generics) {
        return SlicedModel.empty(ResolvableType.forClassWithGenerics(fallbackElementType, (Class[])new Class[]{generics}));
    }

    public static <T> SlicedModel<T> empty(ParameterizedTypeReference<T> fallbackElementType) {
        return SlicedModel.empty(ResolvableType.forType(fallbackElementType));
    }

    public static <T> SlicedModel<T> empty(ResolvableType fallbackElementType) {
        return new SlicedModel(Collections.emptyList(), null, Collections.emptyList(), fallbackElementType);
    }

    public static <T> SlicedModel<T> empty(Link ... links) {
        return SlicedModel.empty(null, links);
    }

    public static <T> SlicedModel<T> empty(Iterable<Link> links) {
        return SlicedModel.empty(null, links);
    }

    public static <T> SlicedModel<T> empty(@Nullable SliceMetadata metadata) {
        return SlicedModel.empty(metadata, Collections.emptyList());
    }

    public static <T> SlicedModel<T> empty(@Nullable SliceMetadata metadata, Class<?> fallbackType, Class<?> ... generics) {
        Assert.notNull(fallbackType, (String)"Fallback type must not be null!");
        Assert.notNull(generics, (String)"Generics must not be null!");
        return SlicedModel.empty(metadata, ResolvableType.forClassWithGenerics(fallbackType, (Class[])generics));
    }

    public static <T> SlicedModel<T> empty(@Nullable SliceMetadata metadata, ParameterizedTypeReference<T> fallbackType) {
        Assert.notNull(fallbackType, (String)"Fallback type must not be null!");
        return SlicedModel.empty(metadata, ResolvableType.forType(fallbackType));
    }

    public static <T> SlicedModel<T> empty(@Nullable SliceMetadata metadata, ResolvableType fallbackType) {
        Assert.notNull((Object)fallbackType, (String)"Fallback type must not be null!");
        return new SlicedModel(Collections.emptyList(), metadata, Collections.emptyList(), fallbackType);
    }

    public static <T> SlicedModel<T> empty(@Nullable SliceMetadata metadata, Link ... links) {
        return SlicedModel.empty(Arrays.asList(links));
    }

    public static <T> SlicedModel<T> empty(@Nullable SliceMetadata metadata, Iterable<Link> links) {
        return SlicedModel.of(Collections.emptyList(), metadata, links);
    }

    public static <T> SlicedModel<T> of(Collection<T> content, @Nullable SliceMetadata metadata) {
        return new SlicedModel<T>(content, metadata);
    }

    public static <T> SlicedModel<T> of(Collection<T> content, @Nullable SliceMetadata metadata, Link ... links) {
        return new SlicedModel<T>(content, metadata, Arrays.asList(links));
    }

    public static <T> SlicedModel<T> of(Collection<T> content, @Nullable SliceMetadata metadata, Iterable<Link> links) {
        return new SlicedModel<T>(content, metadata, links);
    }

    public static <T extends EntityModel<S>, S> SlicedModel<T> wrap(Iterable<S> content, SliceMetadata metadata) {
        Assert.notNull(content, (String)"Content must not be null!");
        ArrayList<EntityModel<S>> resources = new ArrayList<EntityModel<S>>();
        for (S element : content) {
            resources.add(EntityModel.of(element));
        }
        return SlicedModel.of(resources, metadata);
    }

    @Nullable
    @JsonProperty(value="page")
    public SliceMetadata getMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public Optional<Link> getNextLink() {
        return this.getLink(IanaLinkRelations.NEXT);
    }

    @JsonIgnore
    public Optional<Link> getPreviousLink() {
        return this.getLink(IanaLinkRelations.PREV);
    }

    @Override
    public SlicedModel<T> withFallbackType(Class<? super T> type, Class<?> ... generics) {
        return this.withFallbackType(ResolvableType.forClassWithGenerics(type, (Class[])generics));
    }

    @Override
    public SlicedModel<T> withFallbackType(ParameterizedTypeReference<?> type) {
        return this.withFallbackType(ResolvableType.forType(type));
    }

    @Override
    public SlicedModel<T> withFallbackType(ResolvableType type) {
        return new SlicedModel(this.getContent(), this.metadata, this.getLinks(), type);
    }

    @Override
    public String toString() {
        return String.format("SlicedModel { content: %s, fallbackType: %s, metadata: %s, links: %s }", this.getContent(), this.fallbackType, this.metadata, this.getLinks());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SlicedModel that = (SlicedModel)obj;
        return Objects.equals(this.metadata, that.metadata) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.metadata);
    }

    public static class SliceMetadata {
        @JsonProperty
        private long size;
        @JsonProperty
        private long number;

        protected SliceMetadata() {
        }

        public SliceMetadata(long size, long number) {
            Assert.isTrue((size > -1L ? 1 : 0) != 0, (String)"Size must not be negative!");
            Assert.isTrue((number > -1L ? 1 : 0) != 0, (String)"Number must not be negative!");
            this.size = size;
            this.number = number;
        }

        public long getSize() {
            return this.size;
        }

        public long getNumber() {
            return this.number;
        }

        public String toString() {
            return String.format("Metadata: { number: %d, size %d )", this.number, this.size);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            SliceMetadata that = (SliceMetadata)obj;
            return super.equals(that) && Objects.equals(this.number, that.number) && Objects.equals(this.size, that.size);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.number, this.size);
        }
    }
}

