/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.aot;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.hateoas.aot.HypermediaTypesRuntimeHints;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.util.Assert;

class HypermediaTypeAotProcessor
implements BeanRegistrationAotProcessor {
    HypermediaTypeAotProcessor() {
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        EnableHypermediaSupport annotation = (EnableHypermediaSupport)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)registeredBean.getBeanClass(), EnableHypermediaSupport.class);
        if (annotation == null) {
            return null;
        }
        Stream<String> fromConfig = Arrays.stream(annotation.type()).map(EnableHypermediaSupport.HypermediaType::getLocalPackageName);
        Stream<String> mediaTypePackages = Stream.concat(fromConfig, Stream.of("alps", "problem")).map("org.springframework.hateoas.mediatype."::concat);
        List<String> packagesToScan = mediaTypePackages.toList();
        return packagesToScan.isEmpty() ? null : new MediaTypeReflectionAotContribution(packagesToScan);
    }

    static class MediaTypeReflectionAotContribution
    implements BeanRegistrationAotContribution {
        private final List<String> mediaTypePackage;
        private final Set<String> packagesSeen;

        public MediaTypeReflectionAotContribution(List<String> mediaTypePackage) {
            Assert.notNull(mediaTypePackage, (String)"Media type packages must not be null!");
            this.mediaTypePackage = mediaTypePackage;
            this.packagesSeen = new HashSet<String>();
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            this.mediaTypePackage.forEach(it -> {
                if (this.packagesSeen.contains(it)) {
                    return;
                }
                this.packagesSeen.add((String)it);
                new HypermediaTypesRuntimeHints((String)it).registerHints(generationContext.getRuntimeHints(), this.getClass().getClassLoader());
            });
        }
    }
}

