/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsProperty;
import org.springframework.http.HttpMethod;

class HalFormsAffordanceModel
extends AffordanceModel {
    private static final Set<HttpMethod> ENTITY_ALTERING_METHODS = EnumSet.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private final List<HalFormsProperty> inputProperties = this.determineInputs();

    public HalFormsAffordanceModel(String name, Link link, HttpMethod httpMethod, AffordanceModel.InputPayloadMetadata inputType, List<QueryParameter> queryMethodParameters, AffordanceModel.PayloadMetadata outputType) {
        super(name, link, httpMethod, inputType, queryMethodParameters, outputType);
    }

    private List<HalFormsProperty> determineInputs() {
        if (!ENTITY_ALTERING_METHODS.contains(this.getHttpMethod())) {
            return Collections.emptyList();
        }
        return this.getInput().stream().map(AffordanceModel.PropertyMetadata::getName).map(it -> new HalFormsProperty().withName((String)it)).collect(Collectors.toList());
    }

    public List<HalFormsProperty> getInputProperties() {
        return this.inputProperties;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HalFormsAffordanceModel)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HalFormsAffordanceModel that = (HalFormsAffordanceModel)o;
        return Objects.equals(this.inputProperties, that.inputProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inputProperties);
    }
}

