/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.support;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.graphql.server.support.AuthenticationExtractor;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.BearerTokenErrors;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public final class BearerTokenAuthenticationExtractor
implements AuthenticationExtractor {
    public static final String AUTHORIZATION_KEY = "Authorization";
    private static final Pattern authorizationPattern = Pattern.compile("^Bearer (?<token>[a-zA-Z0-9-._~+/]+=*)$", 2);
    private final String authorizationKey;

    public BearerTokenAuthenticationExtractor() {
        this(AUTHORIZATION_KEY);
    }

    public BearerTokenAuthenticationExtractor(String authorizationKey) {
        this.authorizationKey = authorizationKey;
    }

    @Override
    public Mono<Authentication> getAuthentication(Map<String, Object> payload) {
        String authorizationValue = this.getAuthorizationValue(payload);
        if (authorizationValue == null) {
            return Mono.empty();
        }
        if (!StringUtils.startsWithIgnoreCase((String)authorizationValue, (String)"bearer")) {
            BearerTokenError error = BearerTokenErrors.invalidRequest((String)"Not a bearer token");
            return Mono.error((Throwable)new OAuth2AuthenticationException((OAuth2Error)error));
        }
        Matcher matcher = authorizationPattern.matcher(authorizationValue);
        if (!matcher.matches()) {
            BearerTokenError error = BearerTokenErrors.invalidToken((String)"Bearer token is malformed");
            return Mono.error((Throwable)new OAuth2AuthenticationException((OAuth2Error)error));
        }
        String token = matcher.group("token");
        return Mono.just((Object)new BearerTokenAuthenticationToken(token));
    }

    @Nullable
    private String getAuthorizationValue(Map<String, Object> payload) {
        String value = (String)payload.get(this.authorizationKey);
        if (value != null) {
            return value;
        }
        for (String key : payload.keySet()) {
            if (!key.equalsIgnoreCase(this.authorizationKey)) continue;
            return (String)payload.get(key);
        }
        return null;
    }
}

