/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.util.List;
import java.util.Locale;
import org.springframework.graphql.observation.DataLoaderObservationContext;
import org.springframework.graphql.observation.DataLoaderObservationConvention;
import org.springframework.graphql.observation.GraphQlObservationDocumentation;
import org.springframework.util.StringUtils;

public class DefaultDataLoaderObservationConvention
implements DataLoaderObservationConvention {
    private static final String DEFAULT_NAME = "graphql.dataloader";
    private static final KeyValue ERROR_TYPE_NONE = KeyValue.of((KeyName)GraphQlObservationDocumentation.DataLoaderLowCardinalityKeyNames.ERROR_TYPE, (String)"NONE");
    private static final KeyValue LOADER_TYPE_UNKNOWN = KeyValue.of((KeyName)GraphQlObservationDocumentation.DataLoaderLowCardinalityKeyNames.LOADER_NAME, (String)"unknown");
    private static final KeyValue OUTCOME_SUCCESS = KeyValue.of((KeyName)GraphQlObservationDocumentation.DataLoaderLowCardinalityKeyNames.OUTCOME, (String)"SUCCESS");
    private static final KeyValue OUTCOME_ERROR = KeyValue.of((KeyName)GraphQlObservationDocumentation.DataLoaderLowCardinalityKeyNames.OUTCOME, (String)"ERROR");

    public String getName() {
        return DEFAULT_NAME;
    }

    public String getContextualName(DataLoaderObservationContext context) {
        List<?> result = context.getResult();
        if (result.isEmpty()) {
            return "graphql dataloader";
        }
        return "graphql dataloader " + result.get(0).getClass().getSimpleName().toLowerCase(Locale.ROOT);
    }

    public KeyValues getLowCardinalityKeyValues(DataLoaderObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.errorType(context), this.loaderType(context), this.outcome(context)});
    }

    public KeyValues getHighCardinalityKeyValues(DataLoaderObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.loaderSize(context)});
    }

    protected KeyValue errorType(DataLoaderObservationContext context) {
        if (context.getError() != null) {
            return KeyValue.of((KeyName)GraphQlObservationDocumentation.DataLoaderLowCardinalityKeyNames.ERROR_TYPE, (String)context.getError().getClass().getSimpleName());
        }
        return ERROR_TYPE_NONE;
    }

    protected KeyValue loaderType(DataLoaderObservationContext context) {
        if (StringUtils.hasText((String)context.getDataLoader().getName())) {
            return KeyValue.of((KeyName)GraphQlObservationDocumentation.DataLoaderLowCardinalityKeyNames.LOADER_NAME, (String)context.getDataLoader().getName());
        }
        return LOADER_TYPE_UNKNOWN;
    }

    protected KeyValue outcome(DataLoaderObservationContext context) {
        if (context.getError() != null) {
            return OUTCOME_ERROR;
        }
        return OUTCOME_SUCCESS;
    }

    protected KeyValue loaderSize(DataLoaderObservationContext context) {
        return KeyValue.of((KeyName)GraphQlObservationDocumentation.DataLoaderHighCardinalityKeyNames.LOADER_SIZE, (String)String.valueOf(context.getResult().size()));
    }
}

