/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import java.util.List;
import java.util.Map;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.webflux.AbstractGraphQlHttpHandler;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

public class GraphQlHttpHandler
extends AbstractGraphQlHttpHandler {
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = List.of(MediaType.APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_JSON, MediaType.APPLICATION_GRAPHQL);

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler) {
        super(graphQlHandler, null);
    }

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler, CodecConfigurer codecConfigurer) {
        super(graphQlHandler, codecConfigurer);
    }

    @Override
    protected Mono<ServerResponse> prepareResponse(ServerRequest request, WebGraphQlResponse response) {
        ServerResponse.BodyBuilder builder = ServerResponse.ok();
        builder.headers(headers -> headers.putAll((Map)response.getResponseHeaders()));
        builder.contentType(GraphQlHttpHandler.selectResponseMediaType(request));
        return builder.bodyValue(this.encodeResponseIfNecessary(response));
    }

    private static MediaType selectResponseMediaType(ServerRequest serverRequest) {
        for (MediaType accepted : serverRequest.headers().accept()) {
            if (!SUPPORTED_MEDIA_TYPES.contains(accepted)) continue;
            return accepted;
        }
        return MediaType.APPLICATION_JSON;
    }
}

