/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.support;

import java.util.Map;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.WebSocketGraphQlInterceptor;
import org.springframework.graphql.server.WebSocketGraphQlRequest;
import org.springframework.graphql.server.WebSocketSessionInfo;
import org.springframework.graphql.server.support.AuthenticationExtractor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public abstract class AbstractAuthenticationWebSocketInterceptor
implements WebSocketGraphQlInterceptor {
    private final String authenticationAttribute = this.getClass().getName() + ".AUTHENTICATION";
    private final AuthenticationExtractor authenticationExtractor;

    public AbstractAuthenticationWebSocketInterceptor(AuthenticationExtractor authExtractor) {
        this.authenticationExtractor = authExtractor;
    }

    @Override
    public Mono<Object> handleConnectionInitialization(WebSocketSessionInfo info, Map<String, Object> payload) {
        return this.authenticationExtractor.getAuthentication(payload).flatMap(this::authenticate).doOnNext(authentication -> {
            SecurityContextImpl securityContext = new SecurityContextImpl(authentication);
            info.getAttributes().put(this.authenticationAttribute, securityContext);
        }).then(Mono.empty());
    }

    protected abstract Mono<Authentication> authenticate(Authentication var1);

    @Override
    public Mono<WebGraphQlResponse> intercept(WebGraphQlRequest request, WebGraphQlInterceptor.Chain chain) {
        if (!(request instanceof WebSocketGraphQlRequest)) {
            return chain.next(request);
        }
        WebSocketGraphQlRequest webSocketRequest = (WebSocketGraphQlRequest)request;
        Map<String, Object> attributes = webSocketRequest.getSessionInfo().getAttributes();
        SecurityContext securityContext = (SecurityContext)attributes.get(this.authenticationAttribute);
        ContextView contextView = this.getContextToWrite(securityContext);
        return chain.next(request).contextWrite(contextView);
    }

    protected abstract ContextView getContextToWrite(SecurityContext var1);
}

