/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import java.util.Collections;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.graphql.execution.SubscriptionPublisherException;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.webflux.AbstractGraphQlHttpHandler;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GraphQlSseHandler
extends AbstractGraphQlHttpHandler {
    private static final Mono<ServerSentEvent<Map<String, Object>>> COMPLETE_EVENT = Mono.just((Object)ServerSentEvent.builder(Collections.emptyMap()).event("complete").build());

    public GraphQlSseHandler(WebGraphQlHandler graphQlHandler) {
        super(graphQlHandler, null);
    }

    @Override
    protected Mono<ServerResponse> prepareResponse(ServerRequest request, WebGraphQlResponse response) {
        Flux resultFlux;
        if (response.getData() instanceof Publisher) {
            resultFlux = Flux.from((Publisher)((Publisher)response.getData())).map(ExecutionResult::toSpecification).onErrorResume(SubscriptionPublisherException.class, ex -> Mono.just(ex.toMap()));
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("A subscription DataFetcher must return a Publisher: " + response.getData()));
            }
            resultFlux = Flux.just((Object)ExecutionResult.newExecutionResult().addError(GraphQLError.newError().errorType((ErrorClassification)ErrorType.OperationNotSupported).message("SSE handler supports only subscriptions", new Object[0]).build()).build().toSpecification());
        }
        Flux sseFlux = resultFlux.map(event -> ServerSentEvent.builder((Object)event).event("next").build());
        return ServerResponse.ok().contentType(MediaType.TEXT_EVENT_STREAM).body(BodyInserters.fromServerSentEvents((Publisher)sseFlux.concatWith(COMPLETE_EVENT))).onErrorResume(Throwable.class, ex -> ServerResponse.badRequest().build());
    }
}

