/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public final class JsonKeysetCursorStrategy
implements CursorStrategy<Map<String, Object>> {
    private static final ResolvableType MAP_TYPE = ResolvableType.forClassWithGenerics(Map.class, (Class[])new Class[]{String.class, Object.class});
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)JsonKeysetCursorStrategy.class.getClassLoader());
    private final Encoder<?> encoder;
    private final Decoder<?> decoder;
    private final DefaultDataBufferFactory bufferFactory = DefaultDataBufferFactory.sharedInstance;

    public JsonKeysetCursorStrategy() {
        this((CodecConfigurer)JsonKeysetCursorStrategy.initCodecConfigurer());
    }

    private static ServerCodecConfigurer initCodecConfigurer() {
        ServerCodecConfigurer configurer = ServerCodecConfigurer.create();
        if (jackson2Present) {
            JacksonObjectMapperCustomizer.customize((CodecConfigurer)configurer);
        }
        return configurer;
    }

    public JsonKeysetCursorStrategy(CodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, (String)"CodecConfigurer is required");
        this.encoder = JsonKeysetCursorStrategy.findJsonEncoder(codecConfigurer);
        this.decoder = JsonKeysetCursorStrategy.findJsonDecoder(codecConfigurer);
    }

    private static Decoder<?> findJsonDecoder(CodecConfigurer configurer) {
        return configurer.getReaders().stream().filter(reader -> reader.canRead(MAP_TYPE, MediaType.APPLICATION_JSON)).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Decoder"));
    }

    private static Encoder<?> findJsonEncoder(CodecConfigurer configurer) {
        return configurer.getWriters().stream().filter(writer -> writer.canWrite(MAP_TYPE, MediaType.APPLICATION_JSON)).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Encoder"));
    }

    @Override
    public boolean supports(Class<?> targetType) {
        return Map.class.isAssignableFrom(targetType);
    }

    @Override
    public String toCursor(Map<String, Object> keys) {
        return this.encoder.encodeValue(keys, (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, MAP_TYPE, MimeTypeUtils.APPLICATION_JSON, null).toString(StandardCharsets.UTF_8);
    }

    @Override
    public Map<String, Object> fromCursor(String cursor) {
        DefaultDataBuffer buffer = this.bufferFactory.wrap(cursor.getBytes(StandardCharsets.UTF_8));
        Map<String, Object> map = (Map<String, Object>)this.decoder.decode((DataBuffer)buffer, MAP_TYPE, null, null);
        return map != null ? map : Collections.emptyMap();
    }

    private static class JacksonObjectMapperCustomizer {
        private JacksonObjectMapperCustomizer() {
        }

        public static void customize(CodecConfigurer configurer) {
            BasicPolymorphicTypeValidator validator = BasicPolymorphicTypeValidator.builder().allowIfBaseType(Map.class).allowIfSubType("java.time.").allowIfSubType(Calendar.class).allowIfSubType(Date.class).build();
            ObjectMapper mapper = Jackson2ObjectMapperBuilder.json().build();
            mapper.activateDefaultTyping((PolymorphicTypeValidator)validator, ObjectMapper.DefaultTyping.NON_FINAL);
            configurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(mapper, new MimeType[0]));
            configurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(mapper, new MimeType[0]));
        }
    }
}

