/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.ProjectedPayload;
import org.springframework.graphql.data.ArgumentValue;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.Argument;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.util.Assert;

public class ProjectedPayloadMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();

    public ProjectedPayloadMethodArgumentResolver(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        this.projectionFactory.setBeanFactory((BeanFactory)applicationContext);
        ClassLoader classLoader = applicationContext.getClassLoader();
        if (classLoader != null) {
            this.projectionFactory.setBeanClassLoader(classLoader);
        }
    }

    protected SpelAwareProxyProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class<?> type = ProjectedPayloadMethodArgumentResolver.getTargetType(parameter);
        return type.isInterface() && AnnotatedElementUtils.findMergedAnnotation(type, ProjectedPayload.class) != null;
    }

    private static Class<?> getTargetType(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        return type.equals(Optional.class) || type.equals(ArgumentValue.class) ? parameter.nested().getNestedParameterType() : parameter.getParameterType();
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) throws Exception {
        Object value;
        boolean isArgumentValue;
        String name = parameter.hasParameterAnnotation(Argument.class) ? ArgumentMethodArgumentResolver.getArgumentName(parameter) : null;
        Class targetType = parameter.getParameterType();
        boolean isOptional = targetType == Optional.class;
        boolean bl = isArgumentValue = targetType == ArgumentValue.class;
        if (isOptional || isArgumentValue) {
            targetType = parameter.nested().getNestedParameterType();
        }
        Map arguments = environment.getArguments();
        Map rawValue = name != null ? arguments.get(name) : arguments;
        Object object = value = rawValue != null ? this.createProjection(targetType, rawValue) : null;
        if (isOptional) {
            return Optional.ofNullable(value);
        }
        if (isArgumentValue) {
            return name != null && arguments.containsKey(name) ? ArgumentValue.ofNullable(value) : ArgumentValue.omitted();
        }
        return value;
    }

    protected Object createProjection(Class<?> targetType, Object rawValue) {
        return this.projectionFactory.createProjection(targetType, rawValue);
    }
}

