/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.observation;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.concurrent.CompletionStage;
import org.springframework.graphql.observation.DataFetcherObservationContext;
import org.springframework.graphql.observation.DataFetcherObservationConvention;
import org.springframework.graphql.observation.DefaultDataFetcherObservationConvention;
import org.springframework.graphql.observation.DefaultExecutionRequestObservationConvention;
import org.springframework.graphql.observation.ExecutionRequestObservationContext;
import org.springframework.graphql.observation.ExecutionRequestObservationConvention;
import org.springframework.graphql.observation.GraphQlObservationDocumentation;

public class GraphQlObservationInstrumentation
extends SimpleInstrumentation {
    private static final String OBSERVATION_KEY = "micrometer.observation";
    private static final ExecutionRequestObservationConvention DEFAULT_REQUEST_CONVENTION = new DefaultExecutionRequestObservationConvention();
    private static final DataFetcherObservationConvention DEFAULT_DATA_FETCHER_CONVENTION = new DefaultDataFetcherObservationConvention();
    private final ObservationRegistry observationRegistry;
    private final ExecutionRequestObservationConvention requestObservationConvention;
    private final DataFetcherObservationConvention dataFetcherObservationConvention;

    public GraphQlObservationInstrumentation(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
        this.requestObservationConvention = new DefaultExecutionRequestObservationConvention();
        this.dataFetcherObservationConvention = new DefaultDataFetcherObservationConvention();
    }

    public GraphQlObservationInstrumentation(ObservationRegistry observationRegistry, ExecutionRequestObservationConvention requestObservationConvention, DataFetcherObservationConvention dateFetcherObservationConvention) {
        this.observationRegistry = observationRegistry;
        this.requestObservationConvention = requestObservationConvention;
        this.dataFetcherObservationConvention = dateFetcherObservationConvention;
    }

    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return new RequestObservationInstrumentationState();
    }

    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        if (state instanceof RequestObservationInstrumentationState) {
            RequestObservationInstrumentationState instrumentationState = (RequestObservationInstrumentationState)state;
            final ExecutionRequestObservationContext observationContext = new ExecutionRequestObservationContext(parameters.getExecutionInput());
            final Observation requestObservation = instrumentationState.createRequestObservation(this.requestObservationConvention, observationContext, this.observationRegistry);
            requestObservation.start();
            return new SimpleInstrumentationContext<ExecutionResult>(){

                public void onCompleted(ExecutionResult result, Throwable exc) {
                    observationContext.setResponse(result);
                    if (exc != null) {
                        observationContext.setError(exc);
                        requestObservation.error(exc);
                    } else {
                        requestObservation.stop();
                    }
                }
            };
        }
        return super.beginExecution(parameters, state);
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (!parameters.isTrivialDataFetcher() && state instanceof RequestObservationInstrumentationState) {
            RequestObservationInstrumentationState instrumentationState = (RequestObservationInstrumentationState)state;
            return environment -> {
                DataFetcherObservationContext observationContext = new DataFetcherObservationContext(parameters.getEnvironment());
                Observation dataFetcherObservation = instrumentationState.createDataFetcherObservation(this.dataFetcherObservationConvention, observationContext, this.observationRegistry);
                parameters.getExecutionContext().getGraphQLContext().put((Object)OBSERVATION_KEY, (Object)dataFetcherObservation);
                dataFetcherObservation.start();
                try {
                    Object value = dataFetcher.get(environment);
                    if (value instanceof CompletionStage) {
                        CompletionStage completion = (CompletionStage)value;
                        return completion.whenComplete((result, error) -> {
                            if (error != null) {
                                dataFetcherObservation.error(error);
                            }
                            observationContext.setValue(result);
                            dataFetcherObservation.stop();
                        });
                    }
                    observationContext.setValue(value);
                    dataFetcherObservation.stop();
                    return value;
                }
                catch (Throwable throwable) {
                    dataFetcherObservation.error(throwable);
                    dataFetcherObservation.stop();
                    throw throwable;
                }
            };
        }
        return super.instrumentDataFetcher(dataFetcher, parameters, state);
    }

    static class RequestObservationInstrumentationState
    implements InstrumentationState {
        private Observation requestObservation;

        RequestObservationInstrumentationState() {
        }

        Observation createRequestObservation(ExecutionRequestObservationConvention convention, ExecutionRequestObservationContext context, ObservationRegistry registry) {
            Observation observation;
            this.requestObservation = observation = GraphQlObservationDocumentation.EXECUTION_REQUEST.observation(convention, DEFAULT_REQUEST_CONVENTION, () -> context, registry);
            return observation;
        }

        Observation createDataFetcherObservation(DataFetcherObservationConvention convention, DataFetcherObservationContext context, ObservationRegistry registry) {
            Observation dataFetcherObservation = GraphQlObservationDocumentation.DATA_FETCHER.observation(convention, DEFAULT_DATA_FETCHER_CONVENTION, () -> context, registry);
            dataFetcherObservation.parentObservation(this.requestObservation);
            return dataFetcherObservation;
        }
    }
}

